// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file structures.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__STRUCTURES_HPP
#define FAST_DDS_GENERATED__STRUCTURES_HPP

#include <array>
#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <vector>

#include <fastcdr/cdr/fixed_size_string.hpp>
#include "helpers/basic_inner_types.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(STRUCTURES_SOURCE)
#define STRUCTURES_DllAPI __declspec( dllexport )
#else
#define STRUCTURES_DllAPI __declspec( dllimport )
#endif // STRUCTURES_SOURCE
#else
#define STRUCTURES_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define STRUCTURES_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure StructShort defined by the user in the IDL file.
 * @ingroup structures
 */
class StructShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructShort that will be copied.
     */
    eProsima_user_DllExport StructShort(
            const StructShort& x)
    {
                    m_var_short = x.m_var_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructShort that will be copied.
     */
    eProsima_user_DllExport StructShort(
            StructShort&& x) noexcept
    {
        m_var_short = x.m_var_short;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructShort that will be copied.
     */
    eProsima_user_DllExport StructShort& operator =(
            const StructShort& x)
    {

                    m_var_short = x.m_var_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructShort that will be copied.
     */
    eProsima_user_DllExport StructShort& operator =(
            StructShort&& x) noexcept
    {

        m_var_short = x.m_var_short;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructShort& x) const
    {
        return (m_var_short == x.m_var_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_short
     * @param _var_short New value for member var_short
     */
    eProsima_user_DllExport void var_short(
            int16_t _var_short)
    {
        m_var_short = _var_short;
    }

    /*!
     * @brief This function returns the value of member var_short
     * @return Value of member var_short
     */
    eProsima_user_DllExport int16_t var_short() const
    {
        return m_var_short;
    }

    /*!
     * @brief This function returns a reference to member var_short
     * @return Reference to member var_short
     */
    eProsima_user_DllExport int16_t& var_short()
    {
        return m_var_short;
    }



private:

    int16_t m_var_short{0};

};
/*!
 * @brief This class represents the structure StructUnsignedShort defined by the user in the IDL file.
 * @ingroup structures
 */
class StructUnsignedShort
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructUnsignedShort()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructUnsignedShort()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructUnsignedShort that will be copied.
     */
    eProsima_user_DllExport StructUnsignedShort(
            const StructUnsignedShort& x)
    {
                    m_var_ushort = x.m_var_ushort;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructUnsignedShort that will be copied.
     */
    eProsima_user_DllExport StructUnsignedShort(
            StructUnsignedShort&& x) noexcept
    {
        m_var_ushort = x.m_var_ushort;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructUnsignedShort that will be copied.
     */
    eProsima_user_DllExport StructUnsignedShort& operator =(
            const StructUnsignedShort& x)
    {

                    m_var_ushort = x.m_var_ushort;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructUnsignedShort that will be copied.
     */
    eProsima_user_DllExport StructUnsignedShort& operator =(
            StructUnsignedShort&& x) noexcept
    {

        m_var_ushort = x.m_var_ushort;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedShort object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructUnsignedShort& x) const
    {
        return (m_var_ushort == x.m_var_ushort);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedShort object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructUnsignedShort& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ushort
     * @param _var_ushort New value for member var_ushort
     */
    eProsima_user_DllExport void var_ushort(
            uint16_t _var_ushort)
    {
        m_var_ushort = _var_ushort;
    }

    /*!
     * @brief This function returns the value of member var_ushort
     * @return Value of member var_ushort
     */
    eProsima_user_DllExport uint16_t var_ushort() const
    {
        return m_var_ushort;
    }

    /*!
     * @brief This function returns a reference to member var_ushort
     * @return Reference to member var_ushort
     */
    eProsima_user_DllExport uint16_t& var_ushort()
    {
        return m_var_ushort;
    }



private:

    uint16_t m_var_ushort{0};

};
/*!
 * @brief This class represents the structure StructLong defined by the user in the IDL file.
 * @ingroup structures
 */
class StructLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructLong that will be copied.
     */
    eProsima_user_DllExport StructLong(
            const StructLong& x)
    {
                    m_var_long = x.m_var_long;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructLong that will be copied.
     */
    eProsima_user_DllExport StructLong(
            StructLong&& x) noexcept
    {
        m_var_long = x.m_var_long;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructLong that will be copied.
     */
    eProsima_user_DllExport StructLong& operator =(
            const StructLong& x)
    {

                    m_var_long = x.m_var_long;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructLong that will be copied.
     */
    eProsima_user_DllExport StructLong& operator =(
            StructLong&& x) noexcept
    {

        m_var_long = x.m_var_long;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructLong& x) const
    {
        return (m_var_long == x.m_var_long);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_long
     * @param _var_long New value for member var_long
     */
    eProsima_user_DllExport void var_long(
            int32_t _var_long)
    {
        m_var_long = _var_long;
    }

    /*!
     * @brief This function returns the value of member var_long
     * @return Value of member var_long
     */
    eProsima_user_DllExport int32_t var_long() const
    {
        return m_var_long;
    }

    /*!
     * @brief This function returns a reference to member var_long
     * @return Reference to member var_long
     */
    eProsima_user_DllExport int32_t& var_long()
    {
        return m_var_long;
    }



private:

    int32_t m_var_long{0};

};
/*!
 * @brief This class represents the structure StructUnsignedLong defined by the user in the IDL file.
 * @ingroup structures
 */
class StructUnsignedLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructUnsignedLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructUnsignedLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructUnsignedLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLong(
            const StructUnsignedLong& x)
    {
                    m_var_ulong = x.m_var_ulong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructUnsignedLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLong(
            StructUnsignedLong&& x) noexcept
    {
        m_var_ulong = x.m_var_ulong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructUnsignedLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLong& operator =(
            const StructUnsignedLong& x)
    {

                    m_var_ulong = x.m_var_ulong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructUnsignedLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLong& operator =(
            StructUnsignedLong&& x) noexcept
    {

        m_var_ulong = x.m_var_ulong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructUnsignedLong& x) const
    {
        return (m_var_ulong == x.m_var_ulong);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructUnsignedLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulong
     * @param _var_ulong New value for member var_ulong
     */
    eProsima_user_DllExport void var_ulong(
            uint32_t _var_ulong)
    {
        m_var_ulong = _var_ulong;
    }

    /*!
     * @brief This function returns the value of member var_ulong
     * @return Value of member var_ulong
     */
    eProsima_user_DllExport uint32_t var_ulong() const
    {
        return m_var_ulong;
    }

    /*!
     * @brief This function returns a reference to member var_ulong
     * @return Reference to member var_ulong
     */
    eProsima_user_DllExport uint32_t& var_ulong()
    {
        return m_var_ulong;
    }



private:

    uint32_t m_var_ulong{0};

};
/*!
 * @brief This class represents the structure StructLongLong defined by the user in the IDL file.
 * @ingroup structures
 */
class StructLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructLongLong that will be copied.
     */
    eProsima_user_DllExport StructLongLong(
            const StructLongLong& x)
    {
                    m_var_longlong = x.m_var_longlong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructLongLong that will be copied.
     */
    eProsima_user_DllExport StructLongLong(
            StructLongLong&& x) noexcept
    {
        m_var_longlong = x.m_var_longlong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructLongLong that will be copied.
     */
    eProsima_user_DllExport StructLongLong& operator =(
            const StructLongLong& x)
    {

                    m_var_longlong = x.m_var_longlong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructLongLong that will be copied.
     */
    eProsima_user_DllExport StructLongLong& operator =(
            StructLongLong&& x) noexcept
    {

        m_var_longlong = x.m_var_longlong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructLongLong& x) const
    {
        return (m_var_longlong == x.m_var_longlong);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longlong
     * @param _var_longlong New value for member var_longlong
     */
    eProsima_user_DllExport void var_longlong(
            int64_t _var_longlong)
    {
        m_var_longlong = _var_longlong;
    }

    /*!
     * @brief This function returns the value of member var_longlong
     * @return Value of member var_longlong
     */
    eProsima_user_DllExport int64_t var_longlong() const
    {
        return m_var_longlong;
    }

    /*!
     * @brief This function returns a reference to member var_longlong
     * @return Reference to member var_longlong
     */
    eProsima_user_DllExport int64_t& var_longlong()
    {
        return m_var_longlong;
    }



private:

    int64_t m_var_longlong{0};

};
/*!
 * @brief This class represents the structure StructUnsignedLongLong defined by the user in the IDL file.
 * @ingroup structures
 */
class StructUnsignedLongLong
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructUnsignedLongLong()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructUnsignedLongLong()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLongLong(
            const StructUnsignedLongLong& x)
    {
                    m_var_ulonglong = x.m_var_ulonglong;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLongLong(
            StructUnsignedLongLong&& x) noexcept
    {
        m_var_ulonglong = x.m_var_ulonglong;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLongLong& operator =(
            const StructUnsignedLongLong& x)
    {

                    m_var_ulonglong = x.m_var_ulonglong;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructUnsignedLongLong that will be copied.
     */
    eProsima_user_DllExport StructUnsignedLongLong& operator =(
            StructUnsignedLongLong&& x) noexcept
    {

        m_var_ulonglong = x.m_var_ulonglong;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedLongLong object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructUnsignedLongLong& x) const
    {
        return (m_var_ulonglong == x.m_var_ulonglong);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnsignedLongLong object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructUnsignedLongLong& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_ulonglong
     * @param _var_ulonglong New value for member var_ulonglong
     */
    eProsima_user_DllExport void var_ulonglong(
            uint64_t _var_ulonglong)
    {
        m_var_ulonglong = _var_ulonglong;
    }

    /*!
     * @brief This function returns the value of member var_ulonglong
     * @return Value of member var_ulonglong
     */
    eProsima_user_DllExport uint64_t var_ulonglong() const
    {
        return m_var_ulonglong;
    }

    /*!
     * @brief This function returns a reference to member var_ulonglong
     * @return Reference to member var_ulonglong
     */
    eProsima_user_DllExport uint64_t& var_ulonglong()
    {
        return m_var_ulonglong;
    }



private:

    uint64_t m_var_ulonglong{0};

};
/*!
 * @brief This class represents the structure StructFloat defined by the user in the IDL file.
 * @ingroup structures
 */
class StructFloat
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructFloat()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructFloat()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructFloat that will be copied.
     */
    eProsima_user_DllExport StructFloat(
            const StructFloat& x)
    {
                    m_var_float = x.m_var_float;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructFloat that will be copied.
     */
    eProsima_user_DllExport StructFloat(
            StructFloat&& x) noexcept
    {
        m_var_float = x.m_var_float;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructFloat that will be copied.
     */
    eProsima_user_DllExport StructFloat& operator =(
            const StructFloat& x)
    {

                    m_var_float = x.m_var_float;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructFloat that will be copied.
     */
    eProsima_user_DllExport StructFloat& operator =(
            StructFloat&& x) noexcept
    {

        m_var_float = x.m_var_float;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructFloat object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructFloat& x) const
    {
        return (m_var_float == x.m_var_float);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructFloat object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructFloat& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_float
     * @param _var_float New value for member var_float
     */
    eProsima_user_DllExport void var_float(
            float _var_float)
    {
        m_var_float = _var_float;
    }

    /*!
     * @brief This function returns the value of member var_float
     * @return Value of member var_float
     */
    eProsima_user_DllExport float var_float() const
    {
        return m_var_float;
    }

    /*!
     * @brief This function returns a reference to member var_float
     * @return Reference to member var_float
     */
    eProsima_user_DllExport float& var_float()
    {
        return m_var_float;
    }



private:

    float m_var_float{0.0};

};
/*!
 * @brief This class represents the structure StructDouble defined by the user in the IDL file.
 * @ingroup structures
 */
class StructDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructDouble that will be copied.
     */
    eProsima_user_DllExport StructDouble(
            const StructDouble& x)
    {
                    m_var_double = x.m_var_double;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructDouble that will be copied.
     */
    eProsima_user_DllExport StructDouble(
            StructDouble&& x) noexcept
    {
        m_var_double = x.m_var_double;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructDouble that will be copied.
     */
    eProsima_user_DllExport StructDouble& operator =(
            const StructDouble& x)
    {

                    m_var_double = x.m_var_double;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructDouble that will be copied.
     */
    eProsima_user_DllExport StructDouble& operator =(
            StructDouble&& x) noexcept
    {

        m_var_double = x.m_var_double;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructDouble& x) const
    {
        return (m_var_double == x.m_var_double);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_double
     * @param _var_double New value for member var_double
     */
    eProsima_user_DllExport void var_double(
            double _var_double)
    {
        m_var_double = _var_double;
    }

    /*!
     * @brief This function returns the value of member var_double
     * @return Value of member var_double
     */
    eProsima_user_DllExport double var_double() const
    {
        return m_var_double;
    }

    /*!
     * @brief This function returns a reference to member var_double
     * @return Reference to member var_double
     */
    eProsima_user_DllExport double& var_double()
    {
        return m_var_double;
    }



private:

    double m_var_double{0.0};

};
/*!
 * @brief This class represents the structure StructLongDouble defined by the user in the IDL file.
 * @ingroup structures
 */
class StructLongDouble
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructLongDouble()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructLongDouble()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructLongDouble that will be copied.
     */
    eProsima_user_DllExport StructLongDouble(
            const StructLongDouble& x)
    {
                    m_var_longdouble = x.m_var_longdouble;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructLongDouble that will be copied.
     */
    eProsima_user_DllExport StructLongDouble(
            StructLongDouble&& x) noexcept
    {
        m_var_longdouble = x.m_var_longdouble;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructLongDouble that will be copied.
     */
    eProsima_user_DllExport StructLongDouble& operator =(
            const StructLongDouble& x)
    {

                    m_var_longdouble = x.m_var_longdouble;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructLongDouble that will be copied.
     */
    eProsima_user_DllExport StructLongDouble& operator =(
            StructLongDouble&& x) noexcept
    {

        m_var_longdouble = x.m_var_longdouble;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructLongDouble& x) const
    {
        return (m_var_longdouble == x.m_var_longdouble);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructLongDouble object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructLongDouble& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_longdouble
     * @param _var_longdouble New value for member var_longdouble
     */
    eProsima_user_DllExport void var_longdouble(
            long double _var_longdouble)
    {
        m_var_longdouble = _var_longdouble;
    }

    /*!
     * @brief This function returns the value of member var_longdouble
     * @return Value of member var_longdouble
     */
    eProsima_user_DllExport long double var_longdouble() const
    {
        return m_var_longdouble;
    }

    /*!
     * @brief This function returns a reference to member var_longdouble
     * @return Reference to member var_longdouble
     */
    eProsima_user_DllExport long double& var_longdouble()
    {
        return m_var_longdouble;
    }



private:

    long double m_var_longdouble{0.0};

};
/*!
 * @brief This class represents the structure StructBoolean defined by the user in the IDL file.
 * @ingroup structures
 */
class StructBoolean
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructBoolean()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructBoolean()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructBoolean that will be copied.
     */
    eProsima_user_DllExport StructBoolean(
            const StructBoolean& x)
    {
                    m_var_boolean = x.m_var_boolean;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructBoolean that will be copied.
     */
    eProsima_user_DllExport StructBoolean(
            StructBoolean&& x) noexcept
    {
        m_var_boolean = x.m_var_boolean;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructBoolean that will be copied.
     */
    eProsima_user_DllExport StructBoolean& operator =(
            const StructBoolean& x)
    {

                    m_var_boolean = x.m_var_boolean;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructBoolean that will be copied.
     */
    eProsima_user_DllExport StructBoolean& operator =(
            StructBoolean&& x) noexcept
    {

        m_var_boolean = x.m_var_boolean;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoolean object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructBoolean& x) const
    {
        return (m_var_boolean == x.m_var_boolean);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoolean object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructBoolean& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_boolean
     * @param _var_boolean New value for member var_boolean
     */
    eProsima_user_DllExport void var_boolean(
            bool _var_boolean)
    {
        m_var_boolean = _var_boolean;
    }

    /*!
     * @brief This function returns the value of member var_boolean
     * @return Value of member var_boolean
     */
    eProsima_user_DllExport bool var_boolean() const
    {
        return m_var_boolean;
    }

    /*!
     * @brief This function returns a reference to member var_boolean
     * @return Reference to member var_boolean
     */
    eProsima_user_DllExport bool& var_boolean()
    {
        return m_var_boolean;
    }



private:

    bool m_var_boolean{false};

};
/*!
 * @brief This class represents the structure StructOctet defined by the user in the IDL file.
 * @ingroup structures
 */
class StructOctet
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructOctet()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructOctet()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructOctet that will be copied.
     */
    eProsima_user_DllExport StructOctet(
            const StructOctet& x)
    {
                    m_var_octet = x.m_var_octet;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructOctet that will be copied.
     */
    eProsima_user_DllExport StructOctet(
            StructOctet&& x) noexcept
    {
        m_var_octet = x.m_var_octet;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructOctet that will be copied.
     */
    eProsima_user_DllExport StructOctet& operator =(
            const StructOctet& x)
    {

                    m_var_octet = x.m_var_octet;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructOctet that will be copied.
     */
    eProsima_user_DllExport StructOctet& operator =(
            StructOctet&& x) noexcept
    {

        m_var_octet = x.m_var_octet;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructOctet object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructOctet& x) const
    {
        return (m_var_octet == x.m_var_octet);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructOctet object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructOctet& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_octet
     * @param _var_octet New value for member var_octet
     */
    eProsima_user_DllExport void var_octet(
            uint8_t _var_octet)
    {
        m_var_octet = _var_octet;
    }

    /*!
     * @brief This function returns the value of member var_octet
     * @return Value of member var_octet
     */
    eProsima_user_DllExport uint8_t var_octet() const
    {
        return m_var_octet;
    }

    /*!
     * @brief This function returns a reference to member var_octet
     * @return Reference to member var_octet
     */
    eProsima_user_DllExport uint8_t& var_octet()
    {
        return m_var_octet;
    }



private:

    uint8_t m_var_octet{0};

};
/*!
 * @brief This class represents the structure StructChar8 defined by the user in the IDL file.
 * @ingroup structures
 */
class StructChar8
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructChar8()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructChar8()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructChar8 that will be copied.
     */
    eProsima_user_DllExport StructChar8(
            const StructChar8& x)
    {
                    m_var_char8 = x.m_var_char8;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructChar8 that will be copied.
     */
    eProsima_user_DllExport StructChar8(
            StructChar8&& x) noexcept
    {
        m_var_char8 = x.m_var_char8;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructChar8 that will be copied.
     */
    eProsima_user_DllExport StructChar8& operator =(
            const StructChar8& x)
    {

                    m_var_char8 = x.m_var_char8;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructChar8 that will be copied.
     */
    eProsima_user_DllExport StructChar8& operator =(
            StructChar8&& x) noexcept
    {

        m_var_char8 = x.m_var_char8;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructChar8 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructChar8& x) const
    {
        return (m_var_char8 == x.m_var_char8);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructChar8 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructChar8& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char8
     * @param _var_char8 New value for member var_char8
     */
    eProsima_user_DllExport void var_char8(
            char _var_char8)
    {
        m_var_char8 = _var_char8;
    }

    /*!
     * @brief This function returns the value of member var_char8
     * @return Value of member var_char8
     */
    eProsima_user_DllExport char var_char8() const
    {
        return m_var_char8;
    }

    /*!
     * @brief This function returns a reference to member var_char8
     * @return Reference to member var_char8
     */
    eProsima_user_DllExport char& var_char8()
    {
        return m_var_char8;
    }



private:

    char m_var_char8{0};

};
/*!
 * @brief This class represents the structure StructChar16 defined by the user in the IDL file.
 * @ingroup structures
 */
class StructChar16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructChar16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructChar16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructChar16 that will be copied.
     */
    eProsima_user_DllExport StructChar16(
            const StructChar16& x)
    {
                    m_var_char16 = x.m_var_char16;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructChar16 that will be copied.
     */
    eProsima_user_DllExport StructChar16(
            StructChar16&& x) noexcept
    {
        m_var_char16 = x.m_var_char16;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructChar16 that will be copied.
     */
    eProsima_user_DllExport StructChar16& operator =(
            const StructChar16& x)
    {

                    m_var_char16 = x.m_var_char16;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructChar16 that will be copied.
     */
    eProsima_user_DllExport StructChar16& operator =(
            StructChar16&& x) noexcept
    {

        m_var_char16 = x.m_var_char16;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructChar16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructChar16& x) const
    {
        return (m_var_char16 == x.m_var_char16);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructChar16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructChar16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_char16
     * @param _var_char16 New value for member var_char16
     */
    eProsima_user_DllExport void var_char16(
            wchar_t _var_char16)
    {
        m_var_char16 = _var_char16;
    }

    /*!
     * @brief This function returns the value of member var_char16
     * @return Value of member var_char16
     */
    eProsima_user_DllExport wchar_t var_char16() const
    {
        return m_var_char16;
    }

    /*!
     * @brief This function returns a reference to member var_char16
     * @return Reference to member var_char16
     */
    eProsima_user_DllExport wchar_t& var_char16()
    {
        return m_var_char16;
    }



private:

    wchar_t m_var_char16{0};

};
/*!
 * @brief This class represents the structure StructString defined by the user in the IDL file.
 * @ingroup structures
 */
class StructString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructString that will be copied.
     */
    eProsima_user_DllExport StructString(
            const StructString& x)
    {
                    m_var_string = x.m_var_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructString that will be copied.
     */
    eProsima_user_DllExport StructString(
            StructString&& x) noexcept
    {
        m_var_string = std::move(x.m_var_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructString that will be copied.
     */
    eProsima_user_DllExport StructString& operator =(
            const StructString& x)
    {

                    m_var_string = x.m_var_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructString that will be copied.
     */
    eProsima_user_DllExport StructString& operator =(
            StructString&& x) noexcept
    {

        m_var_string = std::move(x.m_var_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructString& x) const
    {
        return (m_var_string == x.m_var_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_string
     * @param _var_string New value to be copied in member var_string
     */
    eProsima_user_DllExport void var_string(
            const std::string& _var_string)
    {
        m_var_string = _var_string;
    }

    /*!
     * @brief This function moves the value in member var_string
     * @param _var_string New value to be moved in member var_string
     */
    eProsima_user_DllExport void var_string(
            std::string&& _var_string)
    {
        m_var_string = std::move(_var_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_string
     * @return Constant reference to member var_string
     */
    eProsima_user_DllExport const std::string& var_string() const
    {
        return m_var_string;
    }

    /*!
     * @brief This function returns a reference to member var_string
     * @return Reference to member var_string
     */
    eProsima_user_DllExport std::string& var_string()
    {
        return m_var_string;
    }



private:

    std::string m_var_string;

};
/*!
 * @brief This class represents the structure StructWString defined by the user in the IDL file.
 * @ingroup structures
 */
class StructWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructWString that will be copied.
     */
    eProsima_user_DllExport StructWString(
            const StructWString& x)
    {
                    m_var_wstring = x.m_var_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructWString that will be copied.
     */
    eProsima_user_DllExport StructWString(
            StructWString&& x) noexcept
    {
        m_var_wstring = std::move(x.m_var_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructWString that will be copied.
     */
    eProsima_user_DllExport StructWString& operator =(
            const StructWString& x)
    {

                    m_var_wstring = x.m_var_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructWString that will be copied.
     */
    eProsima_user_DllExport StructWString& operator =(
            StructWString&& x) noexcept
    {

        m_var_wstring = std::move(x.m_var_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructWString& x) const
    {
        return (m_var_wstring == x.m_var_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_wstring
     * @param _var_wstring New value to be copied in member var_wstring
     */
    eProsima_user_DllExport void var_wstring(
            const std::wstring& _var_wstring)
    {
        m_var_wstring = _var_wstring;
    }

    /*!
     * @brief This function moves the value in member var_wstring
     * @param _var_wstring New value to be moved in member var_wstring
     */
    eProsima_user_DllExport void var_wstring(
            std::wstring&& _var_wstring)
    {
        m_var_wstring = std::move(_var_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_wstring
     * @return Constant reference to member var_wstring
     */
    eProsima_user_DllExport const std::wstring& var_wstring() const
    {
        return m_var_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_wstring
     * @return Reference to member var_wstring
     */
    eProsima_user_DllExport std::wstring& var_wstring()
    {
        return m_var_wstring;
    }



private:

    std::wstring m_var_wstring;

};
/*!
 * @brief This class represents the structure StructBoundedString defined by the user in the IDL file.
 * @ingroup structures
 */
class StructBoundedString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructBoundedString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructBoundedString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructBoundedString that will be copied.
     */
    eProsima_user_DllExport StructBoundedString(
            const StructBoundedString& x)
    {
                    m_var_bounded_string = x.m_var_bounded_string;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructBoundedString that will be copied.
     */
    eProsima_user_DllExport StructBoundedString(
            StructBoundedString&& x) noexcept
    {
        m_var_bounded_string = std::move(x.m_var_bounded_string);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructBoundedString that will be copied.
     */
    eProsima_user_DllExport StructBoundedString& operator =(
            const StructBoundedString& x)
    {

                    m_var_bounded_string = x.m_var_bounded_string;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructBoundedString that will be copied.
     */
    eProsima_user_DllExport StructBoundedString& operator =(
            StructBoundedString&& x) noexcept
    {

        m_var_bounded_string = std::move(x.m_var_bounded_string);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructBoundedString& x) const
    {
        return (m_var_bounded_string == x.m_var_bounded_string);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoundedString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructBoundedString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_bounded_string
     * @param _var_bounded_string New value to be copied in member var_bounded_string
     */
    eProsima_user_DllExport void var_bounded_string(
            const Inner_alias_bounded_string_helper& _var_bounded_string)
    {
        m_var_bounded_string = _var_bounded_string;
    }

    /*!
     * @brief This function moves the value in member var_bounded_string
     * @param _var_bounded_string New value to be moved in member var_bounded_string
     */
    eProsima_user_DllExport void var_bounded_string(
            Inner_alias_bounded_string_helper&& _var_bounded_string)
    {
        m_var_bounded_string = std::move(_var_bounded_string);
    }

    /*!
     * @brief This function returns a constant reference to member var_bounded_string
     * @return Constant reference to member var_bounded_string
     */
    eProsima_user_DllExport const Inner_alias_bounded_string_helper& var_bounded_string() const
    {
        return m_var_bounded_string;
    }

    /*!
     * @brief This function returns a reference to member var_bounded_string
     * @return Reference to member var_bounded_string
     */
    eProsima_user_DllExport Inner_alias_bounded_string_helper& var_bounded_string()
    {
        return m_var_bounded_string;
    }



private:

    Inner_alias_bounded_string_helper m_var_bounded_string;

};
/*!
 * @brief This class represents the structure StructBoundedWString defined by the user in the IDL file.
 * @ingroup structures
 */
class StructBoundedWString
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructBoundedWString()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructBoundedWString()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructBoundedWString that will be copied.
     */
    eProsima_user_DllExport StructBoundedWString(
            const StructBoundedWString& x)
    {
                    m_var_bounded_wstring = x.m_var_bounded_wstring;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructBoundedWString that will be copied.
     */
    eProsima_user_DllExport StructBoundedWString(
            StructBoundedWString&& x) noexcept
    {
        m_var_bounded_wstring = std::move(x.m_var_bounded_wstring);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructBoundedWString that will be copied.
     */
    eProsima_user_DllExport StructBoundedWString& operator =(
            const StructBoundedWString& x)
    {

                    m_var_bounded_wstring = x.m_var_bounded_wstring;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructBoundedWString that will be copied.
     */
    eProsima_user_DllExport StructBoundedWString& operator =(
            StructBoundedWString&& x) noexcept
    {

        m_var_bounded_wstring = std::move(x.m_var_bounded_wstring);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructBoundedWString& x) const
    {
        return (m_var_bounded_wstring == x.m_var_bounded_wstring);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBoundedWString object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructBoundedWString& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_bounded_wstring
     * @param _var_bounded_wstring New value to be copied in member var_bounded_wstring
     */
    eProsima_user_DllExport void var_bounded_wstring(
            const Inner_alias_bounded_wstring_helper& _var_bounded_wstring)
    {
        m_var_bounded_wstring = _var_bounded_wstring;
    }

    /*!
     * @brief This function moves the value in member var_bounded_wstring
     * @param _var_bounded_wstring New value to be moved in member var_bounded_wstring
     */
    eProsima_user_DllExport void var_bounded_wstring(
            Inner_alias_bounded_wstring_helper&& _var_bounded_wstring)
    {
        m_var_bounded_wstring = std::move(_var_bounded_wstring);
    }

    /*!
     * @brief This function returns a constant reference to member var_bounded_wstring
     * @return Constant reference to member var_bounded_wstring
     */
    eProsima_user_DllExport const Inner_alias_bounded_wstring_helper& var_bounded_wstring() const
    {
        return m_var_bounded_wstring;
    }

    /*!
     * @brief This function returns a reference to member var_bounded_wstring
     * @return Reference to member var_bounded_wstring
     */
    eProsima_user_DllExport Inner_alias_bounded_wstring_helper& var_bounded_wstring()
    {
        return m_var_bounded_wstring;
    }



private:

    Inner_alias_bounded_wstring_helper m_var_bounded_wstring;

};
/*!
 * @brief This class represents the structure StructEnum defined by the user in the IDL file.
 * @ingroup structures
 */
class StructEnum
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructEnum()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructEnum()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructEnum that will be copied.
     */
    eProsima_user_DllExport StructEnum(
            const StructEnum& x)
    {
                    m_var_enum = x.m_var_enum;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructEnum that will be copied.
     */
    eProsima_user_DllExport StructEnum(
            StructEnum&& x) noexcept
    {
        m_var_enum = x.m_var_enum;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructEnum that will be copied.
     */
    eProsima_user_DllExport StructEnum& operator =(
            const StructEnum& x)
    {

                    m_var_enum = x.m_var_enum;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructEnum that will be copied.
     */
    eProsima_user_DllExport StructEnum& operator =(
            StructEnum&& x) noexcept
    {

        m_var_enum = x.m_var_enum;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructEnum object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructEnum& x) const
    {
        return (m_var_enum == x.m_var_enum);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructEnum object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructEnum& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_enum
     * @param _var_enum New value for member var_enum
     */
    eProsima_user_DllExport void var_enum(
            InnerEnumHelper _var_enum)
    {
        m_var_enum = _var_enum;
    }

    /*!
     * @brief This function returns the value of member var_enum
     * @return Value of member var_enum
     */
    eProsima_user_DllExport InnerEnumHelper var_enum() const
    {
        return m_var_enum;
    }

    /*!
     * @brief This function returns a reference to member var_enum
     * @return Reference to member var_enum
     */
    eProsima_user_DllExport InnerEnumHelper& var_enum()
    {
        return m_var_enum;
    }



private:

    InnerEnumHelper m_var_enum{InnerEnumHelper::ENUM_VALUE_1};

};
/*!
 * @brief This class represents the structure StructBitMask defined by the user in the IDL file.
 * @ingroup structures
 */
class StructBitMask
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructBitMask()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructBitMask()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructBitMask that will be copied.
     */
    eProsima_user_DllExport StructBitMask(
            const StructBitMask& x)
    {
                    m_var_bitmask = x.m_var_bitmask;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructBitMask that will be copied.
     */
    eProsima_user_DllExport StructBitMask(
            StructBitMask&& x) noexcept
    {
        m_var_bitmask = std::move(x.m_var_bitmask);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructBitMask that will be copied.
     */
    eProsima_user_DllExport StructBitMask& operator =(
            const StructBitMask& x)
    {

                    m_var_bitmask = x.m_var_bitmask;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructBitMask that will be copied.
     */
    eProsima_user_DllExport StructBitMask& operator =(
            StructBitMask&& x) noexcept
    {

        m_var_bitmask = std::move(x.m_var_bitmask);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBitMask object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructBitMask& x) const
    {
        return (m_var_bitmask == x.m_var_bitmask);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBitMask object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructBitMask& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_bitmask
     * @param _var_bitmask New value to be copied in member var_bitmask
     */
    eProsima_user_DllExport void var_bitmask(
            const InnerBitMaskHelper& _var_bitmask)
    {
        m_var_bitmask = _var_bitmask;
    }

    /*!
     * @brief This function moves the value in member var_bitmask
     * @param _var_bitmask New value to be moved in member var_bitmask
     */
    eProsima_user_DllExport void var_bitmask(
            InnerBitMaskHelper&& _var_bitmask)
    {
        m_var_bitmask = std::move(_var_bitmask);
    }

    /*!
     * @brief This function returns a constant reference to member var_bitmask
     * @return Constant reference to member var_bitmask
     */
    eProsima_user_DllExport const InnerBitMaskHelper& var_bitmask() const
    {
        return m_var_bitmask;
    }

    /*!
     * @brief This function returns a reference to member var_bitmask
     * @return Reference to member var_bitmask
     */
    eProsima_user_DllExport InnerBitMaskHelper& var_bitmask()
    {
        return m_var_bitmask;
    }



private:

    InnerBitMaskHelper m_var_bitmask{0};

};
/*!
 * @brief This class represents the structure StructAlias defined by the user in the IDL file.
 * @ingroup structures
 */
class StructAlias
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructAlias()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructAlias()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructAlias that will be copied.
     */
    eProsima_user_DllExport StructAlias(
            const StructAlias& x)
    {
                    m_var_alias = x.m_var_alias;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructAlias that will be copied.
     */
    eProsima_user_DllExport StructAlias(
            StructAlias&& x) noexcept
    {
        m_var_alias = x.m_var_alias;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructAlias that will be copied.
     */
    eProsima_user_DllExport StructAlias& operator =(
            const StructAlias& x)
    {

                    m_var_alias = x.m_var_alias;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructAlias that will be copied.
     */
    eProsima_user_DllExport StructAlias& operator =(
            StructAlias&& x) noexcept
    {

        m_var_alias = x.m_var_alias;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructAlias object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructAlias& x) const
    {
        return (m_var_alias == x.m_var_alias);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructAlias object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructAlias& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member var_alias
     * @param _var_alias New value for member var_alias
     */
    eProsima_user_DllExport void var_alias(
            InnerAliasHelper _var_alias)
    {
        m_var_alias = _var_alias;
    }

    /*!
     * @brief This function returns the value of member var_alias
     * @return Value of member var_alias
     */
    eProsima_user_DllExport InnerAliasHelper var_alias() const
    {
        return m_var_alias;
    }

    /*!
     * @brief This function returns a reference to member var_alias
     * @return Reference to member var_alias
     */
    eProsima_user_DllExport InnerAliasHelper& var_alias()
    {
        return m_var_alias;
    }



private:

    InnerAliasHelper m_var_alias{0};

};
/*!
 * @brief This class represents the structure StructShortArray defined by the user in the IDL file.
 * @ingroup structures
 */
class StructShortArray
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructShortArray()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructShortArray()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructShortArray that will be copied.
     */
    eProsima_user_DllExport StructShortArray(
            const StructShortArray& x)
    {
                    m_var_array_short = x.m_var_array_short;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructShortArray that will be copied.
     */
    eProsima_user_DllExport StructShortArray(
            StructShortArray&& x) noexcept
    {
        m_var_array_short = std::move(x.m_var_array_short);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructShortArray that will be copied.
     */
    eProsima_user_DllExport StructShortArray& operator =(
            const StructShortArray& x)
    {

                    m_var_array_short = x.m_var_array_short;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructShortArray that will be copied.
     */
    eProsima_user_DllExport StructShortArray& operator =(
            StructShortArray&& x) noexcept
    {

        m_var_array_short = std::move(x.m_var_array_short);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructShortArray object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructShortArray& x) const
    {
        return (m_var_array_short == x.m_var_array_short);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructShortArray object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructShortArray& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_array_short
     * @param _var_array_short New value to be copied in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            const std::array<int16_t, 10>& _var_array_short)
    {
        m_var_array_short = _var_array_short;
    }

    /*!
     * @brief This function moves the value in member var_array_short
     * @param _var_array_short New value to be moved in member var_array_short
     */
    eProsima_user_DllExport void var_array_short(
            std::array<int16_t, 10>&& _var_array_short)
    {
        m_var_array_short = std::move(_var_array_short);
    }

    /*!
     * @brief This function returns a constant reference to member var_array_short
     * @return Constant reference to member var_array_short
     */
    eProsima_user_DllExport const std::array<int16_t, 10>& var_array_short() const
    {
        return m_var_array_short;
    }

    /*!
     * @brief This function returns a reference to member var_array_short
     * @return Reference to member var_array_short
     */
    eProsima_user_DllExport std::array<int16_t, 10>& var_array_short()
    {
        return m_var_array_short;
    }



private:

    std::array<int16_t, 10> m_var_array_short{0};

};
/*!
 * @brief This class represents the structure StructSequence defined by the user in the IDL file.
 * @ingroup structures
 */
class StructSequence
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructSequence()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructSequence()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructSequence that will be copied.
     */
    eProsima_user_DllExport StructSequence(
            const StructSequence& x)
    {
                    m_var_sequence = x.m_var_sequence;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructSequence that will be copied.
     */
    eProsima_user_DllExport StructSequence(
            StructSequence&& x) noexcept
    {
        m_var_sequence = std::move(x.m_var_sequence);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructSequence that will be copied.
     */
    eProsima_user_DllExport StructSequence& operator =(
            const StructSequence& x)
    {

                    m_var_sequence = x.m_var_sequence;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructSequence that will be copied.
     */
    eProsima_user_DllExport StructSequence& operator =(
            StructSequence&& x) noexcept
    {

        m_var_sequence = std::move(x.m_var_sequence);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructSequence object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructSequence& x) const
    {
        return (m_var_sequence == x.m_var_sequence);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructSequence object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructSequence& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_sequence
     * @param _var_sequence New value to be copied in member var_sequence
     */
    eProsima_user_DllExport void var_sequence(
            const std::vector<int32_t>& _var_sequence)
    {
        m_var_sequence = _var_sequence;
    }

    /*!
     * @brief This function moves the value in member var_sequence
     * @param _var_sequence New value to be moved in member var_sequence
     */
    eProsima_user_DllExport void var_sequence(
            std::vector<int32_t>&& _var_sequence)
    {
        m_var_sequence = std::move(_var_sequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_sequence
     * @return Constant reference to member var_sequence
     */
    eProsima_user_DllExport const std::vector<int32_t>& var_sequence() const
    {
        return m_var_sequence;
    }

    /*!
     * @brief This function returns a reference to member var_sequence
     * @return Reference to member var_sequence
     */
    eProsima_user_DllExport std::vector<int32_t>& var_sequence()
    {
        return m_var_sequence;
    }



private:

    std::vector<int32_t> m_var_sequence;

};
/*!
 * @brief This class represents the structure StructMap defined by the user in the IDL file.
 * @ingroup structures
 */
class StructMap
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructMap()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructMap()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructMap that will be copied.
     */
    eProsima_user_DllExport StructMap(
            const StructMap& x)
    {
                    m_var_map = x.m_var_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructMap that will be copied.
     */
    eProsima_user_DllExport StructMap(
            StructMap&& x) noexcept
    {
        m_var_map = std::move(x.m_var_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructMap that will be copied.
     */
    eProsima_user_DllExport StructMap& operator =(
            const StructMap& x)
    {

                    m_var_map = x.m_var_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructMap that will be copied.
     */
    eProsima_user_DllExport StructMap& operator =(
            StructMap&& x) noexcept
    {

        m_var_map = std::move(x.m_var_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructMap object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructMap& x) const
    {
        return (m_var_map == x.m_var_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructMap object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructMap& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_map
     * @param _var_map New value to be copied in member var_map
     */
    eProsima_user_DllExport void var_map(
            const std::map<int32_t, int32_t>& _var_map)
    {
        m_var_map = _var_map;
    }

    /*!
     * @brief This function moves the value in member var_map
     * @param _var_map New value to be moved in member var_map
     */
    eProsima_user_DllExport void var_map(
            std::map<int32_t, int32_t>&& _var_map)
    {
        m_var_map = std::move(_var_map);
    }

    /*!
     * @brief This function returns a constant reference to member var_map
     * @return Constant reference to member var_map
     */
    eProsima_user_DllExport const std::map<int32_t, int32_t>& var_map() const
    {
        return m_var_map;
    }

    /*!
     * @brief This function returns a reference to member var_map
     * @return Reference to member var_map
     */
    eProsima_user_DllExport std::map<int32_t, int32_t>& var_map()
    {
        return m_var_map;
    }



private:

    std::map<int32_t, int32_t> m_var_map;

};
/*!
 * @brief This class represents the structure StructUnion defined by the user in the IDL file.
 * @ingroup structures
 */
class StructUnion
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructUnion()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructUnion()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructUnion that will be copied.
     */
    eProsima_user_DllExport StructUnion(
            const StructUnion& x)
    {
                    m_var_union = x.m_var_union;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructUnion that will be copied.
     */
    eProsima_user_DllExport StructUnion(
            StructUnion&& x) noexcept
    {
        m_var_union = std::move(x.m_var_union);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructUnion that will be copied.
     */
    eProsima_user_DllExport StructUnion& operator =(
            const StructUnion& x)
    {

                    m_var_union = x.m_var_union;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructUnion that will be copied.
     */
    eProsima_user_DllExport StructUnion& operator =(
            StructUnion&& x) noexcept
    {

        m_var_union = std::move(x.m_var_union);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnion object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructUnion& x) const
    {
        return (m_var_union == x.m_var_union);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructUnion object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructUnion& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_union
     * @param _var_union New value to be copied in member var_union
     */
    eProsima_user_DllExport void var_union(
            const InnerUnionHelper& _var_union)
    {
        m_var_union = _var_union;
    }

    /*!
     * @brief This function moves the value in member var_union
     * @param _var_union New value to be moved in member var_union
     */
    eProsima_user_DllExport void var_union(
            InnerUnionHelper&& _var_union)
    {
        m_var_union = std::move(_var_union);
    }

    /*!
     * @brief This function returns a constant reference to member var_union
     * @return Constant reference to member var_union
     */
    eProsima_user_DllExport const InnerUnionHelper& var_union() const
    {
        return m_var_union;
    }

    /*!
     * @brief This function returns a reference to member var_union
     * @return Reference to member var_union
     */
    eProsima_user_DllExport InnerUnionHelper& var_union()
    {
        return m_var_union;
    }



private:

    InnerUnionHelper m_var_union;

};
/*!
 * @brief This class represents the structure StructStructure defined by the user in the IDL file.
 * @ingroup structures
 */
class StructStructure
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructStructure()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructStructure()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructStructure that will be copied.
     */
    eProsima_user_DllExport StructStructure(
            const StructStructure& x)
    {
                    m_var_structure = x.m_var_structure;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructStructure that will be copied.
     */
    eProsima_user_DllExport StructStructure(
            StructStructure&& x) noexcept
    {
        m_var_structure = std::move(x.m_var_structure);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructStructure that will be copied.
     */
    eProsima_user_DllExport StructStructure& operator =(
            const StructStructure& x)
    {

                    m_var_structure = x.m_var_structure;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructStructure that will be copied.
     */
    eProsima_user_DllExport StructStructure& operator =(
            StructStructure&& x) noexcept
    {

        m_var_structure = std::move(x.m_var_structure);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructStructure object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructStructure& x) const
    {
        return (m_var_structure == x.m_var_structure);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructStructure object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructStructure& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_structure
     * @param _var_structure New value to be copied in member var_structure
     */
    eProsima_user_DllExport void var_structure(
            const InnerStructureHelper& _var_structure)
    {
        m_var_structure = _var_structure;
    }

    /*!
     * @brief This function moves the value in member var_structure
     * @param _var_structure New value to be moved in member var_structure
     */
    eProsima_user_DllExport void var_structure(
            InnerStructureHelper&& _var_structure)
    {
        m_var_structure = std::move(_var_structure);
    }

    /*!
     * @brief This function returns a constant reference to member var_structure
     * @return Constant reference to member var_structure
     */
    eProsima_user_DllExport const InnerStructureHelper& var_structure() const
    {
        return m_var_structure;
    }

    /*!
     * @brief This function returns a reference to member var_structure
     * @return Reference to member var_structure
     */
    eProsima_user_DllExport InnerStructureHelper& var_structure()
    {
        return m_var_structure;
    }



private:

    InnerStructureHelper m_var_structure;

};
/*!
 * @brief This class represents the structure StructBitset defined by the user in the IDL file.
 * @ingroup structures
 */
class StructBitset
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructBitset()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructBitset()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructBitset that will be copied.
     */
    eProsima_user_DllExport StructBitset(
            const StructBitset& x)
    {
                    m_var_bitset = x.m_var_bitset;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructBitset that will be copied.
     */
    eProsima_user_DllExport StructBitset(
            StructBitset&& x) noexcept
    {
        m_var_bitset = std::move(x.m_var_bitset);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructBitset that will be copied.
     */
    eProsima_user_DllExport StructBitset& operator =(
            const StructBitset& x)
    {

                    m_var_bitset = x.m_var_bitset;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructBitset that will be copied.
     */
    eProsima_user_DllExport StructBitset& operator =(
            StructBitset&& x) noexcept
    {

        m_var_bitset = std::move(x.m_var_bitset);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBitset object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructBitset& x) const
    {
        return (m_var_bitset == x.m_var_bitset);
    }

    /*!
     * @brief Comparison operator.
     * @param x StructBitset object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructBitset& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_bitset
     * @param _var_bitset New value to be copied in member var_bitset
     */
    eProsima_user_DllExport void var_bitset(
            const InnerBitsetHelper& _var_bitset)
    {
        m_var_bitset = _var_bitset;
    }

    /*!
     * @brief This function moves the value in member var_bitset
     * @param _var_bitset New value to be moved in member var_bitset
     */
    eProsima_user_DllExport void var_bitset(
            InnerBitsetHelper&& _var_bitset)
    {
        m_var_bitset = std::move(_var_bitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_bitset
     * @return Constant reference to member var_bitset
     */
    eProsima_user_DllExport const InnerBitsetHelper& var_bitset() const
    {
        return m_var_bitset;
    }

    /*!
     * @brief This function returns a reference to member var_bitset
     * @return Reference to member var_bitset
     */
    eProsima_user_DllExport InnerBitsetHelper& var_bitset()
    {
        return m_var_bitset;
    }



private:

    InnerBitsetHelper m_var_bitset{};

};
/*!
 * @brief This class represents the structure StructEmpty defined by the user in the IDL file.
 * @ingroup structures
 */
class StructEmpty
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport StructEmpty()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~StructEmpty()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object StructEmpty that will be copied.
     */
    eProsima_user_DllExport StructEmpty(
            const StructEmpty& x)
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object StructEmpty that will be copied.
     */
    eProsima_user_DllExport StructEmpty(
            StructEmpty&& x) noexcept
    {
        static_cast<void>(x);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object StructEmpty that will be copied.
     */
    eProsima_user_DllExport StructEmpty& operator =(
            const StructEmpty& x)
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object StructEmpty that will be copied.
     */
    eProsima_user_DllExport StructEmpty& operator =(
            StructEmpty&& x) noexcept
    {

        static_cast<void>(x);

        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructEmpty object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const StructEmpty& x) const
    {
        static_cast<void>(x);
        return true;
    }

    /*!
     * @brief Comparison operator.
     * @param x StructEmpty object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const StructEmpty& x) const
    {
        return !(*this == x);
    }



private:


};
/*!
 * @brief This class represents the structure Structures defined by the user in the IDL file.
 * @ingroup structures
 */
class Structures
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Structures()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Structures()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Structures that will be copied.
     */
    eProsima_user_DllExport Structures(
            const Structures& x)
    {
                    m_var_StructShort = x.m_var_StructShort;

                    m_var_StructUnsignedShort = x.m_var_StructUnsignedShort;

                    m_var_StructLong = x.m_var_StructLong;

                    m_var_StructUnsignedLong = x.m_var_StructUnsignedLong;

                    m_var_StructLongLong = x.m_var_StructLongLong;

                    m_var_StructUnsignedLongLong = x.m_var_StructUnsignedLongLong;

                    m_var_StructFloat = x.m_var_StructFloat;

                    m_var_StructDouble = x.m_var_StructDouble;

                    m_var_StructLongDouble = x.m_var_StructLongDouble;

                    m_var_StructBoolean = x.m_var_StructBoolean;

                    m_var_StructOctet = x.m_var_StructOctet;

                    m_var_StructChar8 = x.m_var_StructChar8;

                    m_var_StructChar16 = x.m_var_StructChar16;

                    m_var_StructString = x.m_var_StructString;

                    m_var_StructWString = x.m_var_StructWString;

                    m_var_StructBoundedString = x.m_var_StructBoundedString;

                    m_var_StructBoundedWString = x.m_var_StructBoundedWString;

                    m_var_StructEnum = x.m_var_StructEnum;

                    m_var_StructBitMask = x.m_var_StructBitMask;

                    m_var_StructAlias = x.m_var_StructAlias;

                    m_var_StructShortArray = x.m_var_StructShortArray;

                    m_var_StructSequence = x.m_var_StructSequence;

                    m_var_StructMap = x.m_var_StructMap;

                    m_var_StructUnion = x.m_var_StructUnion;

                    m_var_StructStructure = x.m_var_StructStructure;

                    m_var_StructBitset = x.m_var_StructBitset;

                    m_var_StructEmpty = x.m_var_StructEmpty;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Structures that will be copied.
     */
    eProsima_user_DllExport Structures(
            Structures&& x) noexcept
    {
        m_var_StructShort = std::move(x.m_var_StructShort);
        m_var_StructUnsignedShort = std::move(x.m_var_StructUnsignedShort);
        m_var_StructLong = std::move(x.m_var_StructLong);
        m_var_StructUnsignedLong = std::move(x.m_var_StructUnsignedLong);
        m_var_StructLongLong = std::move(x.m_var_StructLongLong);
        m_var_StructUnsignedLongLong = std::move(x.m_var_StructUnsignedLongLong);
        m_var_StructFloat = std::move(x.m_var_StructFloat);
        m_var_StructDouble = std::move(x.m_var_StructDouble);
        m_var_StructLongDouble = std::move(x.m_var_StructLongDouble);
        m_var_StructBoolean = std::move(x.m_var_StructBoolean);
        m_var_StructOctet = std::move(x.m_var_StructOctet);
        m_var_StructChar8 = std::move(x.m_var_StructChar8);
        m_var_StructChar16 = std::move(x.m_var_StructChar16);
        m_var_StructString = std::move(x.m_var_StructString);
        m_var_StructWString = std::move(x.m_var_StructWString);
        m_var_StructBoundedString = std::move(x.m_var_StructBoundedString);
        m_var_StructBoundedWString = std::move(x.m_var_StructBoundedWString);
        m_var_StructEnum = std::move(x.m_var_StructEnum);
        m_var_StructBitMask = std::move(x.m_var_StructBitMask);
        m_var_StructAlias = std::move(x.m_var_StructAlias);
        m_var_StructShortArray = std::move(x.m_var_StructShortArray);
        m_var_StructSequence = std::move(x.m_var_StructSequence);
        m_var_StructMap = std::move(x.m_var_StructMap);
        m_var_StructUnion = std::move(x.m_var_StructUnion);
        m_var_StructStructure = std::move(x.m_var_StructStructure);
        m_var_StructBitset = std::move(x.m_var_StructBitset);
        m_var_StructEmpty = std::move(x.m_var_StructEmpty);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Structures that will be copied.
     */
    eProsima_user_DllExport Structures& operator =(
            const Structures& x)
    {

                    m_var_StructShort = x.m_var_StructShort;

                    m_var_StructUnsignedShort = x.m_var_StructUnsignedShort;

                    m_var_StructLong = x.m_var_StructLong;

                    m_var_StructUnsignedLong = x.m_var_StructUnsignedLong;

                    m_var_StructLongLong = x.m_var_StructLongLong;

                    m_var_StructUnsignedLongLong = x.m_var_StructUnsignedLongLong;

                    m_var_StructFloat = x.m_var_StructFloat;

                    m_var_StructDouble = x.m_var_StructDouble;

                    m_var_StructLongDouble = x.m_var_StructLongDouble;

                    m_var_StructBoolean = x.m_var_StructBoolean;

                    m_var_StructOctet = x.m_var_StructOctet;

                    m_var_StructChar8 = x.m_var_StructChar8;

                    m_var_StructChar16 = x.m_var_StructChar16;

                    m_var_StructString = x.m_var_StructString;

                    m_var_StructWString = x.m_var_StructWString;

                    m_var_StructBoundedString = x.m_var_StructBoundedString;

                    m_var_StructBoundedWString = x.m_var_StructBoundedWString;

                    m_var_StructEnum = x.m_var_StructEnum;

                    m_var_StructBitMask = x.m_var_StructBitMask;

                    m_var_StructAlias = x.m_var_StructAlias;

                    m_var_StructShortArray = x.m_var_StructShortArray;

                    m_var_StructSequence = x.m_var_StructSequence;

                    m_var_StructMap = x.m_var_StructMap;

                    m_var_StructUnion = x.m_var_StructUnion;

                    m_var_StructStructure = x.m_var_StructStructure;

                    m_var_StructBitset = x.m_var_StructBitset;

                    m_var_StructEmpty = x.m_var_StructEmpty;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Structures that will be copied.
     */
    eProsima_user_DllExport Structures& operator =(
            Structures&& x) noexcept
    {

        m_var_StructShort = std::move(x.m_var_StructShort);
        m_var_StructUnsignedShort = std::move(x.m_var_StructUnsignedShort);
        m_var_StructLong = std::move(x.m_var_StructLong);
        m_var_StructUnsignedLong = std::move(x.m_var_StructUnsignedLong);
        m_var_StructLongLong = std::move(x.m_var_StructLongLong);
        m_var_StructUnsignedLongLong = std::move(x.m_var_StructUnsignedLongLong);
        m_var_StructFloat = std::move(x.m_var_StructFloat);
        m_var_StructDouble = std::move(x.m_var_StructDouble);
        m_var_StructLongDouble = std::move(x.m_var_StructLongDouble);
        m_var_StructBoolean = std::move(x.m_var_StructBoolean);
        m_var_StructOctet = std::move(x.m_var_StructOctet);
        m_var_StructChar8 = std::move(x.m_var_StructChar8);
        m_var_StructChar16 = std::move(x.m_var_StructChar16);
        m_var_StructString = std::move(x.m_var_StructString);
        m_var_StructWString = std::move(x.m_var_StructWString);
        m_var_StructBoundedString = std::move(x.m_var_StructBoundedString);
        m_var_StructBoundedWString = std::move(x.m_var_StructBoundedWString);
        m_var_StructEnum = std::move(x.m_var_StructEnum);
        m_var_StructBitMask = std::move(x.m_var_StructBitMask);
        m_var_StructAlias = std::move(x.m_var_StructAlias);
        m_var_StructShortArray = std::move(x.m_var_StructShortArray);
        m_var_StructSequence = std::move(x.m_var_StructSequence);
        m_var_StructMap = std::move(x.m_var_StructMap);
        m_var_StructUnion = std::move(x.m_var_StructUnion);
        m_var_StructStructure = std::move(x.m_var_StructStructure);
        m_var_StructBitset = std::move(x.m_var_StructBitset);
        m_var_StructEmpty = std::move(x.m_var_StructEmpty);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Structures object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Structures& x) const
    {
        return (m_var_StructShort == x.m_var_StructShort &&
           m_var_StructUnsignedShort == x.m_var_StructUnsignedShort &&
           m_var_StructLong == x.m_var_StructLong &&
           m_var_StructUnsignedLong == x.m_var_StructUnsignedLong &&
           m_var_StructLongLong == x.m_var_StructLongLong &&
           m_var_StructUnsignedLongLong == x.m_var_StructUnsignedLongLong &&
           m_var_StructFloat == x.m_var_StructFloat &&
           m_var_StructDouble == x.m_var_StructDouble &&
           m_var_StructLongDouble == x.m_var_StructLongDouble &&
           m_var_StructBoolean == x.m_var_StructBoolean &&
           m_var_StructOctet == x.m_var_StructOctet &&
           m_var_StructChar8 == x.m_var_StructChar8 &&
           m_var_StructChar16 == x.m_var_StructChar16 &&
           m_var_StructString == x.m_var_StructString &&
           m_var_StructWString == x.m_var_StructWString &&
           m_var_StructBoundedString == x.m_var_StructBoundedString &&
           m_var_StructBoundedWString == x.m_var_StructBoundedWString &&
           m_var_StructEnum == x.m_var_StructEnum &&
           m_var_StructBitMask == x.m_var_StructBitMask &&
           m_var_StructAlias == x.m_var_StructAlias &&
           m_var_StructShortArray == x.m_var_StructShortArray &&
           m_var_StructSequence == x.m_var_StructSequence &&
           m_var_StructMap == x.m_var_StructMap &&
           m_var_StructUnion == x.m_var_StructUnion &&
           m_var_StructStructure == x.m_var_StructStructure &&
           m_var_StructBitset == x.m_var_StructBitset &&
           m_var_StructEmpty == x.m_var_StructEmpty);
    }

    /*!
     * @brief Comparison operator.
     * @param x Structures object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Structures& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_StructShort
     * @param _var_StructShort New value to be copied in member var_StructShort
     */
    eProsima_user_DllExport void var_StructShort(
            const StructShort& _var_StructShort)
    {
        m_var_StructShort = _var_StructShort;
    }

    /*!
     * @brief This function moves the value in member var_StructShort
     * @param _var_StructShort New value to be moved in member var_StructShort
     */
    eProsima_user_DllExport void var_StructShort(
            StructShort&& _var_StructShort)
    {
        m_var_StructShort = std::move(_var_StructShort);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructShort
     * @return Constant reference to member var_StructShort
     */
    eProsima_user_DllExport const StructShort& var_StructShort() const
    {
        return m_var_StructShort;
    }

    /*!
     * @brief This function returns a reference to member var_StructShort
     * @return Reference to member var_StructShort
     */
    eProsima_user_DllExport StructShort& var_StructShort()
    {
        return m_var_StructShort;
    }


    /*!
     * @brief This function copies the value in member var_StructUnsignedShort
     * @param _var_StructUnsignedShort New value to be copied in member var_StructUnsignedShort
     */
    eProsima_user_DllExport void var_StructUnsignedShort(
            const StructUnsignedShort& _var_StructUnsignedShort)
    {
        m_var_StructUnsignedShort = _var_StructUnsignedShort;
    }

    /*!
     * @brief This function moves the value in member var_StructUnsignedShort
     * @param _var_StructUnsignedShort New value to be moved in member var_StructUnsignedShort
     */
    eProsima_user_DllExport void var_StructUnsignedShort(
            StructUnsignedShort&& _var_StructUnsignedShort)
    {
        m_var_StructUnsignedShort = std::move(_var_StructUnsignedShort);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructUnsignedShort
     * @return Constant reference to member var_StructUnsignedShort
     */
    eProsima_user_DllExport const StructUnsignedShort& var_StructUnsignedShort() const
    {
        return m_var_StructUnsignedShort;
    }

    /*!
     * @brief This function returns a reference to member var_StructUnsignedShort
     * @return Reference to member var_StructUnsignedShort
     */
    eProsima_user_DllExport StructUnsignedShort& var_StructUnsignedShort()
    {
        return m_var_StructUnsignedShort;
    }


    /*!
     * @brief This function copies the value in member var_StructLong
     * @param _var_StructLong New value to be copied in member var_StructLong
     */
    eProsima_user_DllExport void var_StructLong(
            const StructLong& _var_StructLong)
    {
        m_var_StructLong = _var_StructLong;
    }

    /*!
     * @brief This function moves the value in member var_StructLong
     * @param _var_StructLong New value to be moved in member var_StructLong
     */
    eProsima_user_DllExport void var_StructLong(
            StructLong&& _var_StructLong)
    {
        m_var_StructLong = std::move(_var_StructLong);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructLong
     * @return Constant reference to member var_StructLong
     */
    eProsima_user_DllExport const StructLong& var_StructLong() const
    {
        return m_var_StructLong;
    }

    /*!
     * @brief This function returns a reference to member var_StructLong
     * @return Reference to member var_StructLong
     */
    eProsima_user_DllExport StructLong& var_StructLong()
    {
        return m_var_StructLong;
    }


    /*!
     * @brief This function copies the value in member var_StructUnsignedLong
     * @param _var_StructUnsignedLong New value to be copied in member var_StructUnsignedLong
     */
    eProsima_user_DllExport void var_StructUnsignedLong(
            const StructUnsignedLong& _var_StructUnsignedLong)
    {
        m_var_StructUnsignedLong = _var_StructUnsignedLong;
    }

    /*!
     * @brief This function moves the value in member var_StructUnsignedLong
     * @param _var_StructUnsignedLong New value to be moved in member var_StructUnsignedLong
     */
    eProsima_user_DllExport void var_StructUnsignedLong(
            StructUnsignedLong&& _var_StructUnsignedLong)
    {
        m_var_StructUnsignedLong = std::move(_var_StructUnsignedLong);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructUnsignedLong
     * @return Constant reference to member var_StructUnsignedLong
     */
    eProsima_user_DllExport const StructUnsignedLong& var_StructUnsignedLong() const
    {
        return m_var_StructUnsignedLong;
    }

    /*!
     * @brief This function returns a reference to member var_StructUnsignedLong
     * @return Reference to member var_StructUnsignedLong
     */
    eProsima_user_DllExport StructUnsignedLong& var_StructUnsignedLong()
    {
        return m_var_StructUnsignedLong;
    }


    /*!
     * @brief This function copies the value in member var_StructLongLong
     * @param _var_StructLongLong New value to be copied in member var_StructLongLong
     */
    eProsima_user_DllExport void var_StructLongLong(
            const StructLongLong& _var_StructLongLong)
    {
        m_var_StructLongLong = _var_StructLongLong;
    }

    /*!
     * @brief This function moves the value in member var_StructLongLong
     * @param _var_StructLongLong New value to be moved in member var_StructLongLong
     */
    eProsima_user_DllExport void var_StructLongLong(
            StructLongLong&& _var_StructLongLong)
    {
        m_var_StructLongLong = std::move(_var_StructLongLong);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructLongLong
     * @return Constant reference to member var_StructLongLong
     */
    eProsima_user_DllExport const StructLongLong& var_StructLongLong() const
    {
        return m_var_StructLongLong;
    }

    /*!
     * @brief This function returns a reference to member var_StructLongLong
     * @return Reference to member var_StructLongLong
     */
    eProsima_user_DllExport StructLongLong& var_StructLongLong()
    {
        return m_var_StructLongLong;
    }


    /*!
     * @brief This function copies the value in member var_StructUnsignedLongLong
     * @param _var_StructUnsignedLongLong New value to be copied in member var_StructUnsignedLongLong
     */
    eProsima_user_DllExport void var_StructUnsignedLongLong(
            const StructUnsignedLongLong& _var_StructUnsignedLongLong)
    {
        m_var_StructUnsignedLongLong = _var_StructUnsignedLongLong;
    }

    /*!
     * @brief This function moves the value in member var_StructUnsignedLongLong
     * @param _var_StructUnsignedLongLong New value to be moved in member var_StructUnsignedLongLong
     */
    eProsima_user_DllExport void var_StructUnsignedLongLong(
            StructUnsignedLongLong&& _var_StructUnsignedLongLong)
    {
        m_var_StructUnsignedLongLong = std::move(_var_StructUnsignedLongLong);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructUnsignedLongLong
     * @return Constant reference to member var_StructUnsignedLongLong
     */
    eProsima_user_DllExport const StructUnsignedLongLong& var_StructUnsignedLongLong() const
    {
        return m_var_StructUnsignedLongLong;
    }

    /*!
     * @brief This function returns a reference to member var_StructUnsignedLongLong
     * @return Reference to member var_StructUnsignedLongLong
     */
    eProsima_user_DllExport StructUnsignedLongLong& var_StructUnsignedLongLong()
    {
        return m_var_StructUnsignedLongLong;
    }


    /*!
     * @brief This function copies the value in member var_StructFloat
     * @param _var_StructFloat New value to be copied in member var_StructFloat
     */
    eProsima_user_DllExport void var_StructFloat(
            const StructFloat& _var_StructFloat)
    {
        m_var_StructFloat = _var_StructFloat;
    }

    /*!
     * @brief This function moves the value in member var_StructFloat
     * @param _var_StructFloat New value to be moved in member var_StructFloat
     */
    eProsima_user_DllExport void var_StructFloat(
            StructFloat&& _var_StructFloat)
    {
        m_var_StructFloat = std::move(_var_StructFloat);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructFloat
     * @return Constant reference to member var_StructFloat
     */
    eProsima_user_DllExport const StructFloat& var_StructFloat() const
    {
        return m_var_StructFloat;
    }

    /*!
     * @brief This function returns a reference to member var_StructFloat
     * @return Reference to member var_StructFloat
     */
    eProsima_user_DllExport StructFloat& var_StructFloat()
    {
        return m_var_StructFloat;
    }


    /*!
     * @brief This function copies the value in member var_StructDouble
     * @param _var_StructDouble New value to be copied in member var_StructDouble
     */
    eProsima_user_DllExport void var_StructDouble(
            const StructDouble& _var_StructDouble)
    {
        m_var_StructDouble = _var_StructDouble;
    }

    /*!
     * @brief This function moves the value in member var_StructDouble
     * @param _var_StructDouble New value to be moved in member var_StructDouble
     */
    eProsima_user_DllExport void var_StructDouble(
            StructDouble&& _var_StructDouble)
    {
        m_var_StructDouble = std::move(_var_StructDouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructDouble
     * @return Constant reference to member var_StructDouble
     */
    eProsima_user_DllExport const StructDouble& var_StructDouble() const
    {
        return m_var_StructDouble;
    }

    /*!
     * @brief This function returns a reference to member var_StructDouble
     * @return Reference to member var_StructDouble
     */
    eProsima_user_DllExport StructDouble& var_StructDouble()
    {
        return m_var_StructDouble;
    }


    /*!
     * @brief This function copies the value in member var_StructLongDouble
     * @param _var_StructLongDouble New value to be copied in member var_StructLongDouble
     */
    eProsima_user_DllExport void var_StructLongDouble(
            const StructLongDouble& _var_StructLongDouble)
    {
        m_var_StructLongDouble = _var_StructLongDouble;
    }

    /*!
     * @brief This function moves the value in member var_StructLongDouble
     * @param _var_StructLongDouble New value to be moved in member var_StructLongDouble
     */
    eProsima_user_DllExport void var_StructLongDouble(
            StructLongDouble&& _var_StructLongDouble)
    {
        m_var_StructLongDouble = std::move(_var_StructLongDouble);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructLongDouble
     * @return Constant reference to member var_StructLongDouble
     */
    eProsima_user_DllExport const StructLongDouble& var_StructLongDouble() const
    {
        return m_var_StructLongDouble;
    }

    /*!
     * @brief This function returns a reference to member var_StructLongDouble
     * @return Reference to member var_StructLongDouble
     */
    eProsima_user_DllExport StructLongDouble& var_StructLongDouble()
    {
        return m_var_StructLongDouble;
    }


    /*!
     * @brief This function copies the value in member var_StructBoolean
     * @param _var_StructBoolean New value to be copied in member var_StructBoolean
     */
    eProsima_user_DllExport void var_StructBoolean(
            const StructBoolean& _var_StructBoolean)
    {
        m_var_StructBoolean = _var_StructBoolean;
    }

    /*!
     * @brief This function moves the value in member var_StructBoolean
     * @param _var_StructBoolean New value to be moved in member var_StructBoolean
     */
    eProsima_user_DllExport void var_StructBoolean(
            StructBoolean&& _var_StructBoolean)
    {
        m_var_StructBoolean = std::move(_var_StructBoolean);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructBoolean
     * @return Constant reference to member var_StructBoolean
     */
    eProsima_user_DllExport const StructBoolean& var_StructBoolean() const
    {
        return m_var_StructBoolean;
    }

    /*!
     * @brief This function returns a reference to member var_StructBoolean
     * @return Reference to member var_StructBoolean
     */
    eProsima_user_DllExport StructBoolean& var_StructBoolean()
    {
        return m_var_StructBoolean;
    }


    /*!
     * @brief This function copies the value in member var_StructOctet
     * @param _var_StructOctet New value to be copied in member var_StructOctet
     */
    eProsima_user_DllExport void var_StructOctet(
            const StructOctet& _var_StructOctet)
    {
        m_var_StructOctet = _var_StructOctet;
    }

    /*!
     * @brief This function moves the value in member var_StructOctet
     * @param _var_StructOctet New value to be moved in member var_StructOctet
     */
    eProsima_user_DllExport void var_StructOctet(
            StructOctet&& _var_StructOctet)
    {
        m_var_StructOctet = std::move(_var_StructOctet);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructOctet
     * @return Constant reference to member var_StructOctet
     */
    eProsima_user_DllExport const StructOctet& var_StructOctet() const
    {
        return m_var_StructOctet;
    }

    /*!
     * @brief This function returns a reference to member var_StructOctet
     * @return Reference to member var_StructOctet
     */
    eProsima_user_DllExport StructOctet& var_StructOctet()
    {
        return m_var_StructOctet;
    }


    /*!
     * @brief This function copies the value in member var_StructChar8
     * @param _var_StructChar8 New value to be copied in member var_StructChar8
     */
    eProsima_user_DllExport void var_StructChar8(
            const StructChar8& _var_StructChar8)
    {
        m_var_StructChar8 = _var_StructChar8;
    }

    /*!
     * @brief This function moves the value in member var_StructChar8
     * @param _var_StructChar8 New value to be moved in member var_StructChar8
     */
    eProsima_user_DllExport void var_StructChar8(
            StructChar8&& _var_StructChar8)
    {
        m_var_StructChar8 = std::move(_var_StructChar8);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructChar8
     * @return Constant reference to member var_StructChar8
     */
    eProsima_user_DllExport const StructChar8& var_StructChar8() const
    {
        return m_var_StructChar8;
    }

    /*!
     * @brief This function returns a reference to member var_StructChar8
     * @return Reference to member var_StructChar8
     */
    eProsima_user_DllExport StructChar8& var_StructChar8()
    {
        return m_var_StructChar8;
    }


    /*!
     * @brief This function copies the value in member var_StructChar16
     * @param _var_StructChar16 New value to be copied in member var_StructChar16
     */
    eProsima_user_DllExport void var_StructChar16(
            const StructChar16& _var_StructChar16)
    {
        m_var_StructChar16 = _var_StructChar16;
    }

    /*!
     * @brief This function moves the value in member var_StructChar16
     * @param _var_StructChar16 New value to be moved in member var_StructChar16
     */
    eProsima_user_DllExport void var_StructChar16(
            StructChar16&& _var_StructChar16)
    {
        m_var_StructChar16 = std::move(_var_StructChar16);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructChar16
     * @return Constant reference to member var_StructChar16
     */
    eProsima_user_DllExport const StructChar16& var_StructChar16() const
    {
        return m_var_StructChar16;
    }

    /*!
     * @brief This function returns a reference to member var_StructChar16
     * @return Reference to member var_StructChar16
     */
    eProsima_user_DllExport StructChar16& var_StructChar16()
    {
        return m_var_StructChar16;
    }


    /*!
     * @brief This function copies the value in member var_StructString
     * @param _var_StructString New value to be copied in member var_StructString
     */
    eProsima_user_DllExport void var_StructString(
            const StructString& _var_StructString)
    {
        m_var_StructString = _var_StructString;
    }

    /*!
     * @brief This function moves the value in member var_StructString
     * @param _var_StructString New value to be moved in member var_StructString
     */
    eProsima_user_DllExport void var_StructString(
            StructString&& _var_StructString)
    {
        m_var_StructString = std::move(_var_StructString);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructString
     * @return Constant reference to member var_StructString
     */
    eProsima_user_DllExport const StructString& var_StructString() const
    {
        return m_var_StructString;
    }

    /*!
     * @brief This function returns a reference to member var_StructString
     * @return Reference to member var_StructString
     */
    eProsima_user_DllExport StructString& var_StructString()
    {
        return m_var_StructString;
    }


    /*!
     * @brief This function copies the value in member var_StructWString
     * @param _var_StructWString New value to be copied in member var_StructWString
     */
    eProsima_user_DllExport void var_StructWString(
            const StructWString& _var_StructWString)
    {
        m_var_StructWString = _var_StructWString;
    }

    /*!
     * @brief This function moves the value in member var_StructWString
     * @param _var_StructWString New value to be moved in member var_StructWString
     */
    eProsima_user_DllExport void var_StructWString(
            StructWString&& _var_StructWString)
    {
        m_var_StructWString = std::move(_var_StructWString);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructWString
     * @return Constant reference to member var_StructWString
     */
    eProsima_user_DllExport const StructWString& var_StructWString() const
    {
        return m_var_StructWString;
    }

    /*!
     * @brief This function returns a reference to member var_StructWString
     * @return Reference to member var_StructWString
     */
    eProsima_user_DllExport StructWString& var_StructWString()
    {
        return m_var_StructWString;
    }


    /*!
     * @brief This function copies the value in member var_StructBoundedString
     * @param _var_StructBoundedString New value to be copied in member var_StructBoundedString
     */
    eProsima_user_DllExport void var_StructBoundedString(
            const StructBoundedString& _var_StructBoundedString)
    {
        m_var_StructBoundedString = _var_StructBoundedString;
    }

    /*!
     * @brief This function moves the value in member var_StructBoundedString
     * @param _var_StructBoundedString New value to be moved in member var_StructBoundedString
     */
    eProsima_user_DllExport void var_StructBoundedString(
            StructBoundedString&& _var_StructBoundedString)
    {
        m_var_StructBoundedString = std::move(_var_StructBoundedString);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructBoundedString
     * @return Constant reference to member var_StructBoundedString
     */
    eProsima_user_DllExport const StructBoundedString& var_StructBoundedString() const
    {
        return m_var_StructBoundedString;
    }

    /*!
     * @brief This function returns a reference to member var_StructBoundedString
     * @return Reference to member var_StructBoundedString
     */
    eProsima_user_DllExport StructBoundedString& var_StructBoundedString()
    {
        return m_var_StructBoundedString;
    }


    /*!
     * @brief This function copies the value in member var_StructBoundedWString
     * @param _var_StructBoundedWString New value to be copied in member var_StructBoundedWString
     */
    eProsima_user_DllExport void var_StructBoundedWString(
            const StructBoundedWString& _var_StructBoundedWString)
    {
        m_var_StructBoundedWString = _var_StructBoundedWString;
    }

    /*!
     * @brief This function moves the value in member var_StructBoundedWString
     * @param _var_StructBoundedWString New value to be moved in member var_StructBoundedWString
     */
    eProsima_user_DllExport void var_StructBoundedWString(
            StructBoundedWString&& _var_StructBoundedWString)
    {
        m_var_StructBoundedWString = std::move(_var_StructBoundedWString);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructBoundedWString
     * @return Constant reference to member var_StructBoundedWString
     */
    eProsima_user_DllExport const StructBoundedWString& var_StructBoundedWString() const
    {
        return m_var_StructBoundedWString;
    }

    /*!
     * @brief This function returns a reference to member var_StructBoundedWString
     * @return Reference to member var_StructBoundedWString
     */
    eProsima_user_DllExport StructBoundedWString& var_StructBoundedWString()
    {
        return m_var_StructBoundedWString;
    }


    /*!
     * @brief This function copies the value in member var_StructEnum
     * @param _var_StructEnum New value to be copied in member var_StructEnum
     */
    eProsima_user_DllExport void var_StructEnum(
            const StructEnum& _var_StructEnum)
    {
        m_var_StructEnum = _var_StructEnum;
    }

    /*!
     * @brief This function moves the value in member var_StructEnum
     * @param _var_StructEnum New value to be moved in member var_StructEnum
     */
    eProsima_user_DllExport void var_StructEnum(
            StructEnum&& _var_StructEnum)
    {
        m_var_StructEnum = std::move(_var_StructEnum);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructEnum
     * @return Constant reference to member var_StructEnum
     */
    eProsima_user_DllExport const StructEnum& var_StructEnum() const
    {
        return m_var_StructEnum;
    }

    /*!
     * @brief This function returns a reference to member var_StructEnum
     * @return Reference to member var_StructEnum
     */
    eProsima_user_DllExport StructEnum& var_StructEnum()
    {
        return m_var_StructEnum;
    }


    /*!
     * @brief This function copies the value in member var_StructBitMask
     * @param _var_StructBitMask New value to be copied in member var_StructBitMask
     */
    eProsima_user_DllExport void var_StructBitMask(
            const StructBitMask& _var_StructBitMask)
    {
        m_var_StructBitMask = _var_StructBitMask;
    }

    /*!
     * @brief This function moves the value in member var_StructBitMask
     * @param _var_StructBitMask New value to be moved in member var_StructBitMask
     */
    eProsima_user_DllExport void var_StructBitMask(
            StructBitMask&& _var_StructBitMask)
    {
        m_var_StructBitMask = std::move(_var_StructBitMask);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructBitMask
     * @return Constant reference to member var_StructBitMask
     */
    eProsima_user_DllExport const StructBitMask& var_StructBitMask() const
    {
        return m_var_StructBitMask;
    }

    /*!
     * @brief This function returns a reference to member var_StructBitMask
     * @return Reference to member var_StructBitMask
     */
    eProsima_user_DllExport StructBitMask& var_StructBitMask()
    {
        return m_var_StructBitMask;
    }


    /*!
     * @brief This function copies the value in member var_StructAlias
     * @param _var_StructAlias New value to be copied in member var_StructAlias
     */
    eProsima_user_DllExport void var_StructAlias(
            const StructAlias& _var_StructAlias)
    {
        m_var_StructAlias = _var_StructAlias;
    }

    /*!
     * @brief This function moves the value in member var_StructAlias
     * @param _var_StructAlias New value to be moved in member var_StructAlias
     */
    eProsima_user_DllExport void var_StructAlias(
            StructAlias&& _var_StructAlias)
    {
        m_var_StructAlias = std::move(_var_StructAlias);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructAlias
     * @return Constant reference to member var_StructAlias
     */
    eProsima_user_DllExport const StructAlias& var_StructAlias() const
    {
        return m_var_StructAlias;
    }

    /*!
     * @brief This function returns a reference to member var_StructAlias
     * @return Reference to member var_StructAlias
     */
    eProsima_user_DllExport StructAlias& var_StructAlias()
    {
        return m_var_StructAlias;
    }


    /*!
     * @brief This function copies the value in member var_StructShortArray
     * @param _var_StructShortArray New value to be copied in member var_StructShortArray
     */
    eProsima_user_DllExport void var_StructShortArray(
            const StructShortArray& _var_StructShortArray)
    {
        m_var_StructShortArray = _var_StructShortArray;
    }

    /*!
     * @brief This function moves the value in member var_StructShortArray
     * @param _var_StructShortArray New value to be moved in member var_StructShortArray
     */
    eProsima_user_DllExport void var_StructShortArray(
            StructShortArray&& _var_StructShortArray)
    {
        m_var_StructShortArray = std::move(_var_StructShortArray);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructShortArray
     * @return Constant reference to member var_StructShortArray
     */
    eProsima_user_DllExport const StructShortArray& var_StructShortArray() const
    {
        return m_var_StructShortArray;
    }

    /*!
     * @brief This function returns a reference to member var_StructShortArray
     * @return Reference to member var_StructShortArray
     */
    eProsima_user_DllExport StructShortArray& var_StructShortArray()
    {
        return m_var_StructShortArray;
    }


    /*!
     * @brief This function copies the value in member var_StructSequence
     * @param _var_StructSequence New value to be copied in member var_StructSequence
     */
    eProsima_user_DllExport void var_StructSequence(
            const StructSequence& _var_StructSequence)
    {
        m_var_StructSequence = _var_StructSequence;
    }

    /*!
     * @brief This function moves the value in member var_StructSequence
     * @param _var_StructSequence New value to be moved in member var_StructSequence
     */
    eProsima_user_DllExport void var_StructSequence(
            StructSequence&& _var_StructSequence)
    {
        m_var_StructSequence = std::move(_var_StructSequence);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructSequence
     * @return Constant reference to member var_StructSequence
     */
    eProsima_user_DllExport const StructSequence& var_StructSequence() const
    {
        return m_var_StructSequence;
    }

    /*!
     * @brief This function returns a reference to member var_StructSequence
     * @return Reference to member var_StructSequence
     */
    eProsima_user_DllExport StructSequence& var_StructSequence()
    {
        return m_var_StructSequence;
    }


    /*!
     * @brief This function copies the value in member var_StructMap
     * @param _var_StructMap New value to be copied in member var_StructMap
     */
    eProsima_user_DllExport void var_StructMap(
            const StructMap& _var_StructMap)
    {
        m_var_StructMap = _var_StructMap;
    }

    /*!
     * @brief This function moves the value in member var_StructMap
     * @param _var_StructMap New value to be moved in member var_StructMap
     */
    eProsima_user_DllExport void var_StructMap(
            StructMap&& _var_StructMap)
    {
        m_var_StructMap = std::move(_var_StructMap);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructMap
     * @return Constant reference to member var_StructMap
     */
    eProsima_user_DllExport const StructMap& var_StructMap() const
    {
        return m_var_StructMap;
    }

    /*!
     * @brief This function returns a reference to member var_StructMap
     * @return Reference to member var_StructMap
     */
    eProsima_user_DllExport StructMap& var_StructMap()
    {
        return m_var_StructMap;
    }


    /*!
     * @brief This function copies the value in member var_StructUnion
     * @param _var_StructUnion New value to be copied in member var_StructUnion
     */
    eProsima_user_DllExport void var_StructUnion(
            const StructUnion& _var_StructUnion)
    {
        m_var_StructUnion = _var_StructUnion;
    }

    /*!
     * @brief This function moves the value in member var_StructUnion
     * @param _var_StructUnion New value to be moved in member var_StructUnion
     */
    eProsima_user_DllExport void var_StructUnion(
            StructUnion&& _var_StructUnion)
    {
        m_var_StructUnion = std::move(_var_StructUnion);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructUnion
     * @return Constant reference to member var_StructUnion
     */
    eProsima_user_DllExport const StructUnion& var_StructUnion() const
    {
        return m_var_StructUnion;
    }

    /*!
     * @brief This function returns a reference to member var_StructUnion
     * @return Reference to member var_StructUnion
     */
    eProsima_user_DllExport StructUnion& var_StructUnion()
    {
        return m_var_StructUnion;
    }


    /*!
     * @brief This function copies the value in member var_StructStructure
     * @param _var_StructStructure New value to be copied in member var_StructStructure
     */
    eProsima_user_DllExport void var_StructStructure(
            const StructStructure& _var_StructStructure)
    {
        m_var_StructStructure = _var_StructStructure;
    }

    /*!
     * @brief This function moves the value in member var_StructStructure
     * @param _var_StructStructure New value to be moved in member var_StructStructure
     */
    eProsima_user_DllExport void var_StructStructure(
            StructStructure&& _var_StructStructure)
    {
        m_var_StructStructure = std::move(_var_StructStructure);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructStructure
     * @return Constant reference to member var_StructStructure
     */
    eProsima_user_DllExport const StructStructure& var_StructStructure() const
    {
        return m_var_StructStructure;
    }

    /*!
     * @brief This function returns a reference to member var_StructStructure
     * @return Reference to member var_StructStructure
     */
    eProsima_user_DllExport StructStructure& var_StructStructure()
    {
        return m_var_StructStructure;
    }


    /*!
     * @brief This function copies the value in member var_StructBitset
     * @param _var_StructBitset New value to be copied in member var_StructBitset
     */
    eProsima_user_DllExport void var_StructBitset(
            const StructBitset& _var_StructBitset)
    {
        m_var_StructBitset = _var_StructBitset;
    }

    /*!
     * @brief This function moves the value in member var_StructBitset
     * @param _var_StructBitset New value to be moved in member var_StructBitset
     */
    eProsima_user_DllExport void var_StructBitset(
            StructBitset&& _var_StructBitset)
    {
        m_var_StructBitset = std::move(_var_StructBitset);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructBitset
     * @return Constant reference to member var_StructBitset
     */
    eProsima_user_DllExport const StructBitset& var_StructBitset() const
    {
        return m_var_StructBitset;
    }

    /*!
     * @brief This function returns a reference to member var_StructBitset
     * @return Reference to member var_StructBitset
     */
    eProsima_user_DllExport StructBitset& var_StructBitset()
    {
        return m_var_StructBitset;
    }


    /*!
     * @brief This function copies the value in member var_StructEmpty
     * @param _var_StructEmpty New value to be copied in member var_StructEmpty
     */
    eProsima_user_DllExport void var_StructEmpty(
            const StructEmpty& _var_StructEmpty)
    {
        m_var_StructEmpty = _var_StructEmpty;
    }

    /*!
     * @brief This function moves the value in member var_StructEmpty
     * @param _var_StructEmpty New value to be moved in member var_StructEmpty
     */
    eProsima_user_DllExport void var_StructEmpty(
            StructEmpty&& _var_StructEmpty)
    {
        m_var_StructEmpty = std::move(_var_StructEmpty);
    }

    /*!
     * @brief This function returns a constant reference to member var_StructEmpty
     * @return Constant reference to member var_StructEmpty
     */
    eProsima_user_DllExport const StructEmpty& var_StructEmpty() const
    {
        return m_var_StructEmpty;
    }

    /*!
     * @brief This function returns a reference to member var_StructEmpty
     * @return Reference to member var_StructEmpty
     */
    eProsima_user_DllExport StructEmpty& var_StructEmpty()
    {
        return m_var_StructEmpty;
    }



private:

    StructShort m_var_StructShort;
    StructUnsignedShort m_var_StructUnsignedShort;
    StructLong m_var_StructLong;
    StructUnsignedLong m_var_StructUnsignedLong;
    StructLongLong m_var_StructLongLong;
    StructUnsignedLongLong m_var_StructUnsignedLongLong;
    StructFloat m_var_StructFloat;
    StructDouble m_var_StructDouble;
    StructLongDouble m_var_StructLongDouble;
    StructBoolean m_var_StructBoolean;
    StructOctet m_var_StructOctet;
    StructChar8 m_var_StructChar8;
    StructChar16 m_var_StructChar16;
    StructString m_var_StructString;
    StructWString m_var_StructWString;
    StructBoundedString m_var_StructBoundedString;
    StructBoundedWString m_var_StructBoundedWString;
    StructEnum m_var_StructEnum;
    StructBitMask m_var_StructBitMask;
    StructAlias m_var_StructAlias;
    StructShortArray m_var_StructShortArray;
    StructSequence m_var_StructSequence;
    StructMap m_var_StructMap;
    StructUnion m_var_StructUnion;
    StructStructure m_var_StructStructure;
    StructBitset m_var_StructBitset;
    StructEmpty m_var_StructEmpty;

};
namespace testing_1 {

/*!
 * @brief This class represents the structure foo defined by the user in the IDL file.
 * @ingroup structures
 */
class foo
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport foo()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~foo()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo(
            const foo& x)
    {
                    m_a = x.m_a;

                    m_b = x.m_b;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo(
            foo&& x) noexcept
    {
        m_a = x.m_a;
        m_b = x.m_b;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo& operator =(
            const foo& x)
    {

                    m_a = x.m_a;

                    m_b = x.m_b;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo& operator =(
            foo&& x) noexcept
    {

        m_a = x.m_a;
        m_b = x.m_b;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x foo object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const foo& x) const
    {
        return (m_a == x.m_a &&
           m_b == x.m_b);
    }

    /*!
     * @brief Comparison operator.
     * @param x foo object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const foo& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member a
     * @param _a New value for member a
     */
    eProsima_user_DllExport void a(
            int32_t _a)
    {
        m_a = _a;
    }

    /*!
     * @brief This function returns the value of member a
     * @return Value of member a
     */
    eProsima_user_DllExport int32_t a() const
    {
        return m_a;
    }

    /*!
     * @brief This function returns a reference to member a
     * @return Reference to member a
     */
    eProsima_user_DllExport int32_t& a()
    {
        return m_a;
    }


    /*!
     * @brief This function sets a value in member b
     * @param _b New value for member b
     */
    eProsima_user_DllExport void b(
            int32_t _b)
    {
        m_b = _b;
    }

    /*!
     * @brief This function returns the value of member b
     * @return Value of member b
     */
    eProsima_user_DllExport int32_t b() const
    {
        return m_b;
    }

    /*!
     * @brief This function returns a reference to member b
     * @return Reference to member b
     */
    eProsima_user_DllExport int32_t& b()
    {
        return m_b;
    }



private:

    int32_t m_a{0};
    int32_t m_b{0};

};

} // namespace testing_1
namespace testing_2 {

/*!
 * @brief This class represents the structure foo defined by the user in the IDL file.
 * @ingroup structures
 */
class foo
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport foo()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~foo()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo(
            const foo& x)
    {
                    m_d = x.m_d;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo(
            foo&& x) noexcept
    {
        m_d = x.m_d;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo& operator =(
            const foo& x)
    {

                    m_d = x.m_d;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object foo that will be copied.
     */
    eProsima_user_DllExport foo& operator =(
            foo&& x) noexcept
    {

        m_d = x.m_d;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x foo object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const foo& x) const
    {
        return (m_d == x.m_d);
    }

    /*!
     * @brief Comparison operator.
     * @param x foo object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const foo& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member d
     * @param _d New value for member d
     */
    eProsima_user_DllExport void d(
            bool _d)
    {
        m_d = _d;
    }

    /*!
     * @brief This function returns the value of member d
     * @return Value of member d
     */
    eProsima_user_DllExport bool d() const
    {
        return m_d;
    }

    /*!
     * @brief This function returns a reference to member d
     * @return Reference to member d
     */
    eProsima_user_DllExport bool& d()
    {
        return m_d;
    }



private:

    bool m_d{false};

};

} // namespace testing_2
/*!
 * @brief This class represents the structure bar defined by the user in the IDL file.
 * @ingroup structures
 */
class bar
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport bar()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~bar()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object bar that will be copied.
     */
    eProsima_user_DllExport bar(
            const bar& x)
    {
                    m_e = x.m_e;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object bar that will be copied.
     */
    eProsima_user_DllExport bar(
            bar&& x) noexcept
    {
        m_e = x.m_e;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object bar that will be copied.
     */
    eProsima_user_DllExport bar& operator =(
            const bar& x)
    {

                    m_e = x.m_e;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object bar that will be copied.
     */
    eProsima_user_DllExport bar& operator =(
            bar&& x) noexcept
    {

        m_e = x.m_e;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x bar object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const bar& x) const
    {
        return (m_e == x.m_e);
    }

    /*!
     * @brief Comparison operator.
     * @param x bar object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const bar& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member e
     * @param _e New value for member e
     */
    eProsima_user_DllExport void e(
            double _e)
    {
        m_e = _e;
    }

    /*!
     * @brief This function returns the value of member e
     * @return Value of member e
     */
    eProsima_user_DllExport double e() const
    {
        return m_e;
    }

    /*!
     * @brief This function returns a reference to member e
     * @return Reference to member e
     */
    eProsima_user_DllExport double& e()
    {
        return m_e;
    }



private:

    double m_e{0.0};

};
/*!
 * @brief This class represents the structure root1 defined by the user in the IDL file.
 * @ingroup structures
 */
class root1
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport root1()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~root1()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object root1 that will be copied.
     */
    eProsima_user_DllExport root1(
            const root1& x)
    {
                    m_foo_struct = x.m_foo_struct;

                    m_c = x.m_c;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object root1 that will be copied.
     */
    eProsima_user_DllExport root1(
            root1&& x) noexcept
    {
        m_foo_struct = std::move(x.m_foo_struct);
        m_c = x.m_c;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object root1 that will be copied.
     */
    eProsima_user_DllExport root1& operator =(
            const root1& x)
    {

                    m_foo_struct = x.m_foo_struct;

                    m_c = x.m_c;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object root1 that will be copied.
     */
    eProsima_user_DllExport root1& operator =(
            root1&& x) noexcept
    {

        m_foo_struct = std::move(x.m_foo_struct);
        m_c = x.m_c;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x root1 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const root1& x) const
    {
        return (m_foo_struct == x.m_foo_struct &&
           m_c == x.m_c);
    }

    /*!
     * @brief Comparison operator.
     * @param x root1 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const root1& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member foo_struct
     * @param _foo_struct New value to be copied in member foo_struct
     */
    eProsima_user_DllExport void foo_struct(
            const testing_1::foo& _foo_struct)
    {
        m_foo_struct = _foo_struct;
    }

    /*!
     * @brief This function moves the value in member foo_struct
     * @param _foo_struct New value to be moved in member foo_struct
     */
    eProsima_user_DllExport void foo_struct(
            testing_1::foo&& _foo_struct)
    {
        m_foo_struct = std::move(_foo_struct);
    }

    /*!
     * @brief This function returns a constant reference to member foo_struct
     * @return Constant reference to member foo_struct
     */
    eProsima_user_DllExport const testing_1::foo& foo_struct() const
    {
        return m_foo_struct;
    }

    /*!
     * @brief This function returns a reference to member foo_struct
     * @return Reference to member foo_struct
     */
    eProsima_user_DllExport testing_1::foo& foo_struct()
    {
        return m_foo_struct;
    }


    /*!
     * @brief This function sets a value in member c
     * @param _c New value for member c
     */
    eProsima_user_DllExport void c(
            float _c)
    {
        m_c = _c;
    }

    /*!
     * @brief This function returns the value of member c
     * @return Value of member c
     */
    eProsima_user_DllExport float c() const
    {
        return m_c;
    }

    /*!
     * @brief This function returns a reference to member c
     * @return Reference to member c
     */
    eProsima_user_DllExport float& c()
    {
        return m_c;
    }



private:

    testing_1::foo m_foo_struct;
    float m_c{0.0};

};
/*!
 * @brief This class represents the structure root2 defined by the user in the IDL file.
 * @ingroup structures
 */
class root2
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport root2()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~root2()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object root2 that will be copied.
     */
    eProsima_user_DllExport root2(
            const root2& x)
    {
                    m_foo_struct = x.m_foo_struct;

                    m_bar_struct = x.m_bar_struct;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object root2 that will be copied.
     */
    eProsima_user_DllExport root2(
            root2&& x) noexcept
    {
        m_foo_struct = std::move(x.m_foo_struct);
        m_bar_struct = std::move(x.m_bar_struct);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object root2 that will be copied.
     */
    eProsima_user_DllExport root2& operator =(
            const root2& x)
    {

                    m_foo_struct = x.m_foo_struct;

                    m_bar_struct = x.m_bar_struct;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object root2 that will be copied.
     */
    eProsima_user_DllExport root2& operator =(
            root2&& x) noexcept
    {

        m_foo_struct = std::move(x.m_foo_struct);
        m_bar_struct = std::move(x.m_bar_struct);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x root2 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const root2& x) const
    {
        return (m_foo_struct == x.m_foo_struct &&
           m_bar_struct == x.m_bar_struct);
    }

    /*!
     * @brief Comparison operator.
     * @param x root2 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const root2& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member foo_struct
     * @param _foo_struct New value to be copied in member foo_struct
     */
    eProsima_user_DllExport void foo_struct(
            const testing_2::foo& _foo_struct)
    {
        m_foo_struct = _foo_struct;
    }

    /*!
     * @brief This function moves the value in member foo_struct
     * @param _foo_struct New value to be moved in member foo_struct
     */
    eProsima_user_DllExport void foo_struct(
            testing_2::foo&& _foo_struct)
    {
        m_foo_struct = std::move(_foo_struct);
    }

    /*!
     * @brief This function returns a constant reference to member foo_struct
     * @return Constant reference to member foo_struct
     */
    eProsima_user_DllExport const testing_2::foo& foo_struct() const
    {
        return m_foo_struct;
    }

    /*!
     * @brief This function returns a reference to member foo_struct
     * @return Reference to member foo_struct
     */
    eProsima_user_DllExport testing_2::foo& foo_struct()
    {
        return m_foo_struct;
    }


    /*!
     * @brief This function copies the value in member bar_struct
     * @param _bar_struct New value to be copied in member bar_struct
     */
    eProsima_user_DllExport void bar_struct(
            const bar& _bar_struct)
    {
        m_bar_struct = _bar_struct;
    }

    /*!
     * @brief This function moves the value in member bar_struct
     * @param _bar_struct New value to be moved in member bar_struct
     */
    eProsima_user_DllExport void bar_struct(
            bar&& _bar_struct)
    {
        m_bar_struct = std::move(_bar_struct);
    }

    /*!
     * @brief This function returns a constant reference to member bar_struct
     * @return Constant reference to member bar_struct
     */
    eProsima_user_DllExport const bar& bar_struct() const
    {
        return m_bar_struct;
    }

    /*!
     * @brief This function returns a reference to member bar_struct
     * @return Reference to member bar_struct
     */
    eProsima_user_DllExport bar& bar_struct()
    {
        return m_bar_struct;
    }



private:

    testing_2::foo m_foo_struct;
    bar m_bar_struct;

};
/*!
 * @brief This class represents the structure root defined by the user in the IDL file.
 * @ingroup structures
 */
class root
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport root()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~root()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object root that will be copied.
     */
    eProsima_user_DllExport root(
            const root& x)
    {
                    m_var_root1 = x.m_var_root1;

                    m_var_root2 = x.m_var_root2;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object root that will be copied.
     */
    eProsima_user_DllExport root(
            root&& x) noexcept
    {
        m_var_root1 = std::move(x.m_var_root1);
        m_var_root2 = std::move(x.m_var_root2);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object root that will be copied.
     */
    eProsima_user_DllExport root& operator =(
            const root& x)
    {

                    m_var_root1 = x.m_var_root1;

                    m_var_root2 = x.m_var_root2;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object root that will be copied.
     */
    eProsima_user_DllExport root& operator =(
            root&& x) noexcept
    {

        m_var_root1 = std::move(x.m_var_root1);
        m_var_root2 = std::move(x.m_var_root2);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x root object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const root& x) const
    {
        return (m_var_root1 == x.m_var_root1 &&
           m_var_root2 == x.m_var_root2);
    }

    /*!
     * @brief Comparison operator.
     * @param x root object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const root& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member var_root1
     * @param _var_root1 New value to be copied in member var_root1
     */
    eProsima_user_DllExport void var_root1(
            const root1& _var_root1)
    {
        m_var_root1 = _var_root1;
    }

    /*!
     * @brief This function moves the value in member var_root1
     * @param _var_root1 New value to be moved in member var_root1
     */
    eProsima_user_DllExport void var_root1(
            root1&& _var_root1)
    {
        m_var_root1 = std::move(_var_root1);
    }

    /*!
     * @brief This function returns a constant reference to member var_root1
     * @return Constant reference to member var_root1
     */
    eProsima_user_DllExport const root1& var_root1() const
    {
        return m_var_root1;
    }

    /*!
     * @brief This function returns a reference to member var_root1
     * @return Reference to member var_root1
     */
    eProsima_user_DllExport root1& var_root1()
    {
        return m_var_root1;
    }


    /*!
     * @brief This function copies the value in member var_root2
     * @param _var_root2 New value to be copied in member var_root2
     */
    eProsima_user_DllExport void var_root2(
            const root2& _var_root2)
    {
        m_var_root2 = _var_root2;
    }

    /*!
     * @brief This function moves the value in member var_root2
     * @param _var_root2 New value to be moved in member var_root2
     */
    eProsima_user_DllExport void var_root2(
            root2&& _var_root2)
    {
        m_var_root2 = std::move(_var_root2);
    }

    /*!
     * @brief This function returns a constant reference to member var_root2
     * @return Constant reference to member var_root2
     */
    eProsima_user_DllExport const root2& var_root2() const
    {
        return m_var_root2;
    }

    /*!
     * @brief This function returns a reference to member var_root2
     * @return Reference to member var_root2
     */
    eProsima_user_DllExport root2& var_root2()
    {
        return m_var_root2;
    }



private:

    root1 m_var_root1;
    root2 m_var_root2;

};

#endif // _FAST_DDS_GENERATED_STRUCTURES_HPP_


