// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file relative_path_includeTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "relative_path_includeTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "relative_path_include.hpp"

#include "../IDL/helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;

// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_RelativePathIncludeStruct_type_identifier(
        TypeIdentifierPair& type_ids_RelativePathIncludeStruct)
{

    ReturnCode_t return_code_RelativePathIncludeStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_RelativePathIncludeStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "RelativePathIncludeStruct", type_ids_RelativePathIncludeStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_RelativePathIncludeStruct)
    {
        StructTypeFlag struct_flags_RelativePathIncludeStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_RelativePathIncludeStruct = "RelativePathIncludeStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_RelativePathIncludeStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_RelativePathIncludeStruct;
        CompleteTypeDetail detail_RelativePathIncludeStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_RelativePathIncludeStruct, ann_custom_RelativePathIncludeStruct, type_name_RelativePathIncludeStruct.to_string());
        CompleteStructHeader header_RelativePathIncludeStruct;
        header_RelativePathIncludeStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_RelativePathIncludeStruct);
        CompleteStructMemberSeq member_seq_RelativePathIncludeStruct;
        {
            TypeIdentifierPair type_ids_value;
            ReturnCode_t return_code_value {eprosima::fastdds::dds::RETCODE_OK};
            return_code_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "InnerEnumHelper", type_ids_value);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_value)
            {
            ::register_InnerEnumHelper_type_identifier(type_ids_value);
            }
            StructMemberFlag member_flags_value = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_value = 0x00000000;
            bool common_value_ec {false};
            CommonStructMember common_value {TypeObjectUtils::build_common_struct_member(member_id_value, member_flags_value, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_value, common_value_ec))};
            if (!common_value_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure value member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_value = "value";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_value;
            ann_custom_RelativePathIncludeStruct.reset();
            CompleteMemberDetail detail_value = TypeObjectUtils::build_complete_member_detail(name_value, member_ann_builtin_value, ann_custom_RelativePathIncludeStruct);
            CompleteStructMember member_value = TypeObjectUtils::build_complete_struct_member(common_value, detail_value);
            TypeObjectUtils::add_complete_struct_member(member_seq_RelativePathIncludeStruct, member_value);
        }
        CompleteStructType struct_type_RelativePathIncludeStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_RelativePathIncludeStruct, header_RelativePathIncludeStruct, member_seq_RelativePathIncludeStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_RelativePathIncludeStruct, type_name_RelativePathIncludeStruct.to_string(), type_ids_RelativePathIncludeStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "RelativePathIncludeStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

