// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file deadlinepayload.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "KeyedHelloWorld.h"

#include <fastcdr/Cdr.h>

#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>

KeyedHelloWorld::KeyedHelloWorld()
{
    m_index = 0;
    m_key = 0;
}

KeyedHelloWorld::~KeyedHelloWorld()
{
}

KeyedHelloWorld::KeyedHelloWorld(const KeyedHelloWorld &x)
{
    m_index = x.m_index;
    m_key = x.m_key;
    m_message = x.m_message;
}

KeyedHelloWorld::KeyedHelloWorld(KeyedHelloWorld &&x)
{
    m_index = x.m_index;
    m_key = x.m_key;
    m_message = std::move(x.m_message);
}

KeyedHelloWorld& KeyedHelloWorld::operator=(const KeyedHelloWorld &x)
{
    m_index = x.m_index;
    m_key = x.m_key;
    m_message = x.m_message;
    
    return *this;
}

KeyedHelloWorld& KeyedHelloWorld::operator=(KeyedHelloWorld &&x)
{
    m_index = x.m_index;
    m_key = x.m_key;
    m_message = std::move(x.m_message);
    
    return *this;
}

bool KeyedHelloWorld::operator==(const KeyedHelloWorld &x) const
{
    if(m_index == x.m_index &&
            m_message == x.m_message &&
            m_key == x.m_key)
        return true;

    return false;
}

size_t KeyedHelloWorld::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 256 + 1;
    return current_alignment - initial_alignment;
}

size_t KeyedHelloWorld::getCdrSerializedSize(const KeyedHelloWorld& data, size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.message().size() + 1;
    return current_alignment - initial_alignment;
}

void KeyedHelloWorld::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_key;
    scdr << m_index;

    if(m_message.length() <= 256)
    {
        scdr << m_message;
    }
    else
    {
        throw eprosima::fastcdr::exception::BadParamException("payload field exceeds the maximum length");
    }
}

void KeyedHelloWorld::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_key;
    dcdr >> m_index;
    dcdr >> m_message;
}

size_t KeyedHelloWorld::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
    current_align += 2 + eprosima::fastcdr::Cdr::alignment(current_align, 2);
    return current_align;
}

bool KeyedHelloWorld::isKeyDefined()
{
    return true;
}

void KeyedHelloWorld::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
     scdr << m_key;
}
