# Copyright (C) 2004-2005 Masao Mutoh, Laurent Sansonetti, Mathieu Blondel

copyright = <<EOS
# This file is automatically generated by the installer.
# Do not edit by hands.
EOS

File.open('config.rb', 'w') do |file|
begin
    file.print <<EOS

module Fantasdic
    module Config
        MAIN_DATA_DIR = '#{config('data-dir')}'
        DATA_DIR = '#{config('data-dir')}/fantasdic'
        LIB_DIR = '#{config('rb-dir')}'
    end
end
EOS
rescue NoMethodError
end
end

File.open('version.rb', 'w') do |file|
    begin
        version = IO.readlines('../../VERSION').join.chomp
    rescue Errno::ENOENT
        version = "SVN"
    end
    file.print <<EOS
# This file is automatically generated by the installer.
# Do not edit by hands.

module Fantasdic
    VERSION = "#{version}"
end
EOS
end

def arr_inspect(arr)
    str = "["
    str += arr.collect { |e| "\"#{e}\"" }.join(",")
    str += "]"
end

def hash_inspect(hsh)
    str = "{\n"
    hsh.keys.each do |key|
        arr = hsh[key]
            str += "\"#{key}\" =>  #{arr_inspect(arr)}"
        str += ", " unless hsh.keys.last == key
        str += "\n"
    end
    str += "}\n"
end

File.open('authors.rb', 'w') do |file|
    begin
        authors = IO.readlines('../../AUTHORS').join.chomp.split("\n")
        file.print <<EOS
# This file is automatically generated by the installer.
# Do not edit by hands.

module Fantasdic
    AUTHORS = #{arr_inspect(authors)}
end
EOS
    rescue Errno::ENOENT
    end
end

File.open('translators.rb', 'w') do |file|
    begin
        last_lang = nil
        hsh = {}
        translators = IO.readlines('../../po/AUTHORS').each do |line|
            case line
                when /(.*) \((.*)\)/
                    last_lang = $2
                when /(.*) \<(.*)\>/
                    name, email = $1, $2
                    hsh[last_lang] ||= []
                    hsh[last_lang] << "#{name} <#{email}>"
            end
        end
        file.print <<EOS
# This file is automatically generated by the installer.
# Do not edit by hands.

module Fantasdic
    TRANSLATORS = #{hash_inspect(hsh)}
end
EOS
    rescue Errno::ENOENT
    end
end

File.open('documenters.rb', 'w') do |file|
    begin
        documenters = IO.readlines('../../data/gnome/help/fantasdic/AUTHORS').
                      join.chomp.split("\n")
        file.print <<EOS
# This file is automatically generated by the installer.
# Do not edit by hands.

module Fantasdic
    DOCUMENTERS = #{arr_inspect(documenters)}
end
EOS
    rescue Errno::ENOENT
    end
end
