# Fantasdic
# Copyright (C) 2006 Mathieu Blondel
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

File.open('fantasdic', 'w') do |file|
    file.print <<EOF
#!/path/to/ruby
#
# This file is automatically generated by the installer.
# Do not edit by hands.

\$KCODE = "u"
Thread.abort_on_exception = true

begin
    require 'gettext'
rescue LoadError
    require 'fantasdic/gettext'
    $stderr.puts 'WARNING : Ruby/Gettext was not found.'
end

require 'fantasdic'

begin
    Fantasdic.main
rescue => e
    $stderr.puts <<EOS
-----------------------
Fantasdic just crashed
-----------------------
Timestamp: \#{Time.now}
Message: \#{e.message}
Backtrace:
\#{e.backtrace.join("\\n")}
Release: \#{Fantasdic::VERSION}
Uname -a: \#{`uname -a`.chomp}
--
Please report this dump to '\#{Fantasdic::BUGZILLA}' with some additional
information, such as the description of the crash and the steps to reproduce it
(if it's possible).
EOS
    exit 1
end
EOF
end

if RUBY_PLATFORM =~ /win32/
	File.open('fantasdic.bat','w') do |file|
		file.print <<EOF
rubyw c:/ruby/bin/fantasdic
EOF
	end
end
	