"""
Copyright © 2020-2023 Ralph Seichter

This file is part of "Fangfrisch".

Fangfrisch is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Fangfrisch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Fangfrisch. If not, see <https://www.gnu.org/licenses/>.
"""
from fangfrisch.config import INTEGRITY_CHECK
from fangfrisch.config import INTERVAL
from fangfrisch.config import PREFIX

malwarepatrol = {
    'malwarepatrol': {
        INTERVAL: '1d',
        INTEGRITY_CHECK: 'disabled',
        'product': '8',
        'receipt': 'you_forgot_to_configure_receipt',
        PREFIX: r'https://lists.malwarepatrol.net/cgi/getfile?product=${product}&receipt=${receipt}&list=',
        'url_clamav_basic': f'${{{PREFIX}}}clamav_basic',
        'filename_clamav_basic': 'malwarepatrol.db',
    }
}
