/*
   FALCON - The Falcon Programming Language.
   FILE: socket_ext.cpp
   $Id: confparser_ext.h,v 1.7 2007/07/21 11:59:13 jonnymind Exp $

   Falcon VM interface to confparser module -- header.
   -------------------------------------------------------------------
   Author: Giancarlo Niccolai
   Begin: 2006-05-09 15:50
   Last modified because:

   -------------------------------------------------------------------
   (C) Copyright 2004: the FALCON developers (see list in AUTHORS file)

   See LICENSE file for licensing details.
   In order to use this file in its compiled form, this source or
   part of it you have to read, understand and accept the conditions
   that are stated in the LICENSE file that comes boundled with this
   package.
*/

/** \file
   Falcon VM interface to confparser module -- header.
*/


#ifndef FLC_CONFPARSER_EXT_H
#define FLC_CONFPARSER_EXT_H

#include <falcon/setup.h>
#include <falcon/module.h>

namespace Falcon {
namespace Ext {

// ==============================================
// Class ConfParser
// ==============================================
FALCON_FUNC  ConfParser_init( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_read( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_write( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_get( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getOne( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getMultiple( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getSections( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getKeys( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getCategoryKeys( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getCategory( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_removeCategory( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_getDictionary( ::Falcon::VMachine *vm );

FALCON_FUNC  ConfParser_add( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_set( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_remove( ::Falcon::VMachine *vm );

FALCON_FUNC  ConfParser_addSection( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_removeSection( ::Falcon::VMachine *vm );
FALCON_FUNC  ConfParser_clearMain( ::Falcon::VMachine *vm );

}
}

#endif

/* end of socket_ext.h */
