{
  Gestion LinEx FacturLinEx

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit importar;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, db, FileUtil, LResources, Forms, Controls, Graphics,
  Dialogs, ExtCtrls, Buttons, StdCtrls, Grids, ComCtrls, DBGrids, ZConnection,
  ZDataset, SynEdit, LCLType;

type

  { TfImportar }

  TfImportar = class(TForm)
    btnGenerar: TBitBtn;
    btnSeleccionar: TBitBtn;
    btnSalir: TBitBtn;
    dbEans: TZQuery;
    dsProcesados: TDatasource;
    dsPendientes: TDatasource;
    dbArti: TZQuery;
    dbConnect: TZConnection;
    dbgPendientes: TDBGrid;
    dbgProcesados: TDBGrid;
    eCodigoDesde: TEdit;
    eDelimitador: TEdit;
    eEANDesde: TEdit;
    eEANHasta: TEdit;
    eCodigoHasta: TEdit;
    eCostoDesde: TEdit;
    eCostoHasta: TEdit;
    eDecCostoDesde: TEdit;
    eDecCostoHasta: TEdit;
    eDecPVPDesde: TEdit;
    eDecPVPHasta: TEdit;
    eIVADesde: TEdit;
    eIVAHasta: TEdit;
    eNombreDesde: TEdit;
    eNombreHasta: TEdit;
    eOCodigo: TEdit;
    eOEAN: TEdit;
    eOCosto: TEdit;
    eOIVA: TEdit;
    eONombre: TEdit;
    eOPVP: TEdit;
    eOUnidades: TEdit;
    ePos: TEdit;
    ePVPDesde: TEdit;
    ePVPHasta: TEdit;
    eUnidDesde: TEdit;
    eUnidHasta: TEdit;
    Label1: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label2: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label3: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Memo1: TMemo;
    OpenDialog1: TOpenDialog;
    LoadDialog: TOpenDialog;
    Panel3: TPanel;
    Panel4: TPanel;
    pc: TPageControl;
    Panel1: TPanel;
    Panel2: TPanel;
    SaveDialog: TSaveDialog;
    sbLimpiar2: TSpeedButton;
    sbLoad1: TSpeedButton;
    sbSave1: TSpeedButton;
    sbLimpiar1: TSpeedButton;
    sgDatos: TStringGrid;
    SpeedButton1: TSpeedButton;
    sbSave2: TSpeedButton;
    sbLoad2: TSpeedButton;
    SynEdit1: TSynEdit;
    tsProcesados: TTabSheet;
    tsPendientes: TTabSheet;
    tsSeleccion: TTabSheet;
    tsDelimitado: TTabSheet;
    procedure btnGenerarClick(Sender: TObject);
    procedure btnSalirClick(Sender: TObject);
    procedure btnSeleccionarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure MostrarPosicion(Sender: TObject);
    procedure IniciaImportar(dbPedido: TZQuery);
    procedure sbLimpiar1Click(Sender: TObject);
    procedure sbLimpiar2Click(Sender: TObject);
    procedure sbLoad1Click(Sender: TObject);
    procedure sbLoad2Click(Sender: TObject);
    procedure sbSave2Click(Sender: TObject);
    procedure sgDatosDrawCell(Sender: TObject; aCol, aRow: Integer;
      aRect: TRect; aState: TGridDrawState);
    procedure sbSave1Click(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end;

  procedure ShowFormImportar;

var
  fImportar: TfImportar;
  dbPedid: TZQuery;
  ColorLineas: TColor;

implementation

{ TfImportar }

uses
   Global, Funciones;

//=============== CREAR EL FORMULARIO ================
procedure TfImportar.IniciaImportar(dbPedido: TZQuery);
begin
   dbPedid:= dbPedido;
   ShowFormImportar;
end;

procedure TfImportar.sbLimpiar1Click(Sender: TObject);
begin
 eEANDesde.Text:='';  eEANHasta.Text:='';
 eCodigoDesde.Text:='';  eCodigoHasta.Text:='';
 eNombreDesde.Text:='';  eNombreHasta.Text:='';
 eUnidDesde.Text:='';  eUnidHasta.Text:='';
 eCostoDesde.Text:='';  eCostoHasta.Text:='';
 eDecCostoDesde.Text:='';  eDecCostoHasta.Text:='';
 eIVADesde.Text:='';  eIVAHasta.Text:='';
 ePVPDesde.Text:='';  ePVPHasta.Text:='';
 eDecPVPDesde.Text:='';  eDecPVPHasta.Text:='';
end;

procedure TfImportar.sbLimpiar2Click(Sender: TObject);
begin
 eDelimitador.Text:=',';
 eOEAN.Text:='';
 eOCodigo.Text:='';
 eONombre.Text:='';
 eOUnidades.Text:='';
 eOIVA.Text:='';
 eOCosto.Text:='';
 eOPVP.Text:='';
end;

procedure TfImportar.sbLoad1Click(Sender: TObject);
var
  F: TextFile;
  Txt: String;
begin
  LoadDialog.DefaultExt:='.selp';   // selp = Fichero de Selección de Posiciones
  LoadDialog.Filter:='Selección de Posiciones (*.selp)|*.selp';
  LoadDialog.InitialDir:=Lee+'selecciones';
  if LoadDialog.Execute then begin
     AssignFile(F,LoadDialog.FileName);
     Reset(F);
                      // Usamos IntToStr(StrToInt( )) para eliminar los CEROS. Lo ideal sería una función en *f_cadenas.pas* para eliminar un carácter de una cadena. *** PARA HACER ***.
     ReadLn(F,Txt); eEANDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eEANHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eCodigoDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eCodigoHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eNombreDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eNombreHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eUnidDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eUnidHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eCostoDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eCostoHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eDecCostoDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eDecCostoHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eIVADesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eIVAHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); ePVPDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  ePVPHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     ReadLn(F,Txt); eDecPVPDesde.Text:=IntToStr(StrToInt(Copy(Txt,12,5)));  eDecPVPHasta.Text:=IntToStr(StrToInt(Copy(Txt,18,5)));
     CloseFile(F);
  end;
end;

procedure TfImportar.sbLoad2Click(Sender: TObject);
var
  F: TextFile;
  Txt: String;
begin
  LoadDialog.DefaultExt:='.seld';   // selp = Fichero de Selección Delimitado por Comas
  LoadDialog.Filter:='Selección Delimitado por Comas (*.seld)|*.seld';
  LoadDialog.InitialDir:=Lee+'selecciones';
  if LoadDialog.Execute then begin
     AssignFile(F,LoadDialog.FileName);
     Reset(F);
                      // Usamos IntToStr(StrToInt( )) para eliminar los CEROS. Lo ideal sería una función en *f_cadenas.pas* para eliminar un carácter de una cadena. *** PARA HACER ***.
     ReadLn(F,Txt); eDelimitador.Text:=Copy(Txt,13,1);
     ReadLn(F,Txt); eOEAN.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eOCodigo.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eONombre.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eOUnidades.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eOIVA.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eOCosto.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     ReadLn(F,Txt); eOPVP.Text:=IntToStr(StrToInt(Copy(Txt,13,2)));
     CloseFile(F);
  end;
end;

procedure TfImportar.sbSave2Click(Sender: TObject);
var
  F: TFileStream;
  s: String;
begin
  SaveDialog.DefaultExt:='.seld';   // seld = Fichero de Selección Delimitado por Comas
  SaveDialog.Filter:='Selección Delimitado por Comas (*.seld)|*.seld';
  SaveDialog.InitialDir:=Lee+'selecciones';
  if SaveDialog.Execute then begin
     if FileExists(SaveDialog.FileName) then
        begin
          if Application.MessageBox('¡EL FICHERO DE SELECCION YA EXISTE!' +
            #13 + '¿DESEA REEMPLAZARLO?', 'FacturLinEx',
            MB_ICONQUESTION + MB_YESNO) = idYes then
            DeleteFile(SaveDialog.FileName)
          else
            abort;
        end;
     F := TFileStream.Create(SaveDialog.FileName, fmCreate);
     s := 'DELIMITADOR=' + eDelimitador.Text + #13 + #10;  F.Write(s[1],Length(s));
     s := 'EAN        =' + DataModule1.lFill(eOEAN.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'CODIGO     =' + DataModule1.lFill(eoCodigo.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'NOMBRE     =' + DataModule1.lFill(eONombre.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'UNIDADES   =' + DataModule1.lFill(eOUnidades.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'IVA        =' + DataModule1.lFill(eOIVA.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'COSTO      =' + DataModule1.lFill(eOCosto.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'PRECIO PVP =' + DataModule1.lFill(eOPVP.Text,2,'0') + #13 + #10;  F.Write(s[1],Length(s));
     F.Free;
  end;
end;

procedure TfImportar.sgDatosDrawCell(Sender: TObject; aCol, aRow: Integer;
  aRect: TRect; aState: TGridDrawState);
begin
   sgDatos.Canvas.Font.Color:= ColorLineas;
   sgDatos.DefaultDrawCell(aCol, aRow, aRect, aState);
end;

procedure TfImportar.sbSave1Click(Sender: TObject);
var
  F: TFileStream;
  s: String;
begin
  SaveDialog.DefaultExt:='.selp';   // selp = Fichero de Selección de Posiciones
  SaveDialog.Filter:='Selección de Posiciones (*.selp)|*.selp';
  SaveDialog.InitialDir:=Lee+'selecciones';
  if SaveDialog.Execute then begin
     if FileExists(SaveDialog.FileName) then
        begin
          if Application.MessageBox('¡EL FICHERO DE SELECCION YA EXISTE!' +
            #13 + '¿DESEA REEMPLAZARLO?', 'FacturLinEx',
            MB_ICONQUESTION + MB_YESNO) = idYes then
            DeleteFile(SaveDialog.FileName)
          else
            abort;
        end;
     F := TFileStream.Create(SaveDialog.FileName, fmCreate);
     s := 'EAN       =' + DataModule1.lFill(eEANDesde.Text,5,'0') + ' ' + DataModule1.lFill(eEANHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'CODIGO    =' + DataModule1.lFill(eCodigoDesde.Text,5,'0') + ' ' + DataModule1.lFill(eCodigoHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'NOMBRE    =' + DataModule1.lFill(eNombreDesde.Text,5,'0') + ' ' + DataModule1.lFill(eNombreHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'UNIDADES  =' + DataModule1.lFill(eUnidDesde.Text,5,'0') + ' ' + DataModule1.lFill(eUnidHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'COSTO     =' + DataModule1.lFill(eCostoDesde.Text,5,'0') + ' ' + DataModule1.lFill(eCostoHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'DEC. COSTO=' + DataModule1.lFill(eDecCostoDesde.Text,5,'0') + ' ' + DataModule1.lFill(eDecCostoHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'IVA       =' + DataModule1.lFill(eIVADesde.Text,5,'0') + ' ' + DataModule1.lFill(eIVAHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'PRECIO PVP=' + DataModule1.lFill(ePVPDesde.Text,5,'0') + ' ' + DataModule1.lFill(ePVPHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     s := 'DEC. PVP  =' + DataModule1.lFill(eDecPVPDesde.Text,5,'0') + ' ' + DataModule1.lFill(eDecPVPHasta.Text,5,'0') + #13 + #10;  F.Write(s[1],Length(s));
     F.Free;
  end;
end;

procedure ShowFormImportar;
begin
  with TfImportar.Create(Application) do
    begin
       ShowModal;
    end;
end;

procedure TfImportar.btnSalirClick(Sender: TObject);
begin
  Self.Close;
end;

procedure TfImportar.btnGenerarClick(Sender: TObject);
var
  FicheroTXT, Txt, TxtTEMP: String;
  F: TextFile;
  cont, contdel, PosIni, PosFin: integer;
  datos: array [1..7] of string;
  CodigoEAN, Codigo, Descripcion: string;
begin
  if Memo1.Lines.Count=0 then begin
     ShowMessage('DEBE SELECCIONAR EL FICHERO DE TEXTO A IMPORTAR');
     abort;
  end;
  if pc.ActivePage=tsSeleccion then begin   // Activada la pestaña de Selección de Posiciones
     cont:=2;
     FicheroTXT:=OpenDialog1.FileName;
     AssignFile(F,FicheroTXT);
     Reset(F);
     while not EOF(F) do begin
           Readln(F,Txt);
           // Extraemos los datos requeridos de la linea cargada
           // Comprobamos que los campos no están en blanco para evitar errores
           if ((eEANDesde.Text<>'') and (eEANHasta.Text<>'')) then CodigoEAN:= copy(Txt,StrToInt(eEANDesde.Text),StrToInt(eEANHasta.Text)-StrToInt(eEANDesde.Text)+1);
//            sgDatos.Cells[0,cont-1]:=copy(Txt,StrToInt(eEANDesde.Text),StrToInt(eEANHasta.Text)-StrToInt(eEANDesde.Text)+1);

           if ((eCodigoDesde.Text<>'') and (eCodigoHasta.Text<>'')) then Codigo:=copy(Txt,StrToInt(eCodigoDesde.Text),StrToInt(eCodigoHasta.Text)-StrToInt(eCodigoDesde.Text)+1);
//              sgDatos.Cells[1,cont-1]:=copy(Txt,StrToInt(eCodigoDesde.Text),StrToInt(eCodigoHasta.Text)-StrToInt(eCodigoDesde.Text)+1);

           if ((eNombreDesde.Text<>'') and (eNombreHasta.Text<>'')) then Descripcion:=copy(Txt,StrToInt(eNombreDesde.Text),StrToInt(eNombreHasta.Text)-StrToInt(eNombreDesde.Text)+1);
//              sgDatos.Cells[2,cont-1]:=copy(Txt,StrToInt(eNombreDesde.Text),StrToInt(eNombreHasta.Text)-StrToInt(eNombreDesde.Text)+1);


           ColorLineas:=clRed;

           dbArti.Active:=False;
           dbArti.SQL.Text:='SELECT * FROM artitien'+Tienda+' WHERE A1="'+Descripcion+'"';
           dbArti.Active:=True;
           if (dbArti.RecordCount<>0) then ColorLineas:=clGreen;

           dbEans.Active:=False;
           dbEans.SQL.Text:='SELECT * FROM eans WHERE EAN2="'+Descripcion+'"';
           dbEans.Active:=True;
           if (dbEans.RecordCount<>0) then ColorLineas:=clYellow;

           dbEans.Active:=False;
           dbEans.SQL.Text:='SELECT * FROM eans WHERE EAN0="'+CodigoEAN+'"';
           dbEans.Active:=True;
           if dbEans.RecordCount<>0 then ColorLineas:= clBlack;

           dbArti.Active:=False;
           dbArti.SQL.Text:='SELECT * FROM artitien'+Tienda+' WHERE A0="'+Codigo+'"';
           dbArti.Active:=True;
           if dbArti.RecordCount<>0 then ColorLineas:= clBlack;

           if ((eEANDesde.Text<>'') and (eEANHasta.Text<>'')) then sgDatos.Cells[0,cont-1]:=CodigoEan;
           if ((eCodigoDesde.Text<>'') and (eCodigoHasta.Text<>'')) then sgDatos.Cells[1,cont-1]:=Codigo;
           if ((eNombreDesde.Text<>'') and (eNombreHasta.Text<>'')) then sgDatos.Cells[2,cont-1]:=Descripcion;
           if ((eUnidDesde.Text<>'') and (eUnidHasta.Text<>'')) then
              sgDatos.Cells[3,cont-1]:=copy(Txt,StrToInt(eUnidDesde.Text),StrToInt(eUnidHasta.Text)-StrToInt(eUnidDesde.Text)+1);
           if ((eCostoDesde.Text<>'') and (eCostoHasta.Text<>'') and (eDecCostoDesde.Text<>'') and (eDecCostoHasta.Text<>'')) then
              sgDatos.Cells[4,cont-1]:=copy(Txt,StrToInt(eCostoDesde.Text),StrToInt(eCostoHasta.Text)-StrToInt(eCostoDesde.Text))+','+
                                       copy(Txt,StrToInt(eDecCostoDesde.Text),StrToInt(eDecCostoHasta.Text)-StrToInt(eDecCostoDesde.Text)+1);
           if ((eIVADesde.Text<>'') and (eIVAHasta.Text<>'')) then
              sgDatos.Cells[5,cont-1]:=copy(Txt,StrToInt(eIVADesde.Text),StrToInt(eIVAHasta.Text)-StrToInt(eIVADesde.Text)+1);
           if ((ePVPDesde.Text<>'') and (ePVPHasta.Text<>'') and (eDecPVPDesde.Text<>'') and (eDecPVPHasta.Text<>'')) then
              sgDatos.Cells[6,cont-1]:=copy(Txt,StrToInt(ePVPDesde.Text),StrToInt(ePVPHasta.Text)-StrToInt(ePVPDesde.Text))+','+
                                       copy(Txt,StrToInt(eDecPVPDesde.Text),StrToInt(eDecPVPHasta.Text)-StrToInt(eDecPVPDesde.Text)+1);
           cont:=cont+1;
           sgDatos.RowCount:=cont;
     end;
     CloseFile(F);
  end else begin    // Activada la pestaña de Delimitado por Comas
     if eDelimitador.Text='' then begin
        ShowMessage('DEBE INDICAR EL CARACTER DELIMITADOR');
        abort;
     end;
     cont:=2;
     FicheroTXT:=OpenDialog1.FileName;
     AssignFile(F,FicheroTXT);
     Reset(F);
     while not EOF(F) do begin
           Readln(F,Txt);
           // Extraemos los datos requeridos de la linea cargada
           // Comprobamos que los campos no están en blanco para evitar errores
           TxtTemp:=Txt;   // Necesitamos una variable temporal porque hay que recargarla para cada valor
           if (eOEAN.Text<>'') then begin
              if eOEAN.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOEAN.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);     // Borramos todo el texto anterior que ya hemos revisado
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[0,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eOCodigo.Text<>'') then begin
              if eOCodigo.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOCodigo.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[1,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eONombre.Text<>'') then begin
              if eONombre.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eONombre.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[2,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eOUnidades.Text<>'') then begin
              if eOUnidades.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOUnidades.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[3,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eOIVA.Text<>'') then begin
              if eOIVA.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOIVA.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[4,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eOCosto.Text<>'') then begin
              if eOCosto.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOCosto.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[5,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           TxtTemp:=Txt;
           if (eOPVP.Text<>'') then begin
              if eOPVP.Text='1' then begin
                 PosIni:=1
              end else begin
                 for contdel:=1 to (StrToInt(eOPVP.Text)-1) do begin
                     PosIni:=Pos(eDelimitador.Text,TxtTemp);
                     Delete(TxtTemp,1,PosIni);
                 end;
              end;
              PosFin:=Pos(eDelimitador.Text,TxtTemp);
              sgDatos.Cells[6,cont-1]:=copy(TxtTemp,1,PosFin-1);
           end;
           cont:=cont+1;
           sgDatos.RowCount:=cont;
     end;
     CloseFile(F);
  end;
end;

procedure TfImportar.btnSeleccionarClick(Sender: TObject);
var
  FicheroTXT, Txt: String;
  F: TextFile;
begin
  Memo1.Clear;
  Panel2.Enabled:=false;
  Panel3.Enabled:=false;

  OpenDialog1.InitialDir:=ExtractFilePath(ParamStr(0));

  if OpenDialog1.Execute then begin
     FicheroTXT:=OpenDialog1.FileName;
     // Seleccionamos sólo la primera linea para contar posiciones
     AssignFile(F,FicheroTXT);
     Reset(F);
     Readln(F,Txt);
     SynEdit1.Lines.Add(Txt);
     CloseFile(F);

     // Cargamos todo el contenido del fichero
     AssignFile(F,FicheroTXT);
     Reset(F);
     while not EOF(F) do begin
           Readln(F,Txt);
           Memo1.Lines.Add(Txt);
     end;
     CloseFile(F);
     Panel2.Enabled:=true;
     Panel3.Enabled:=true;
  end else
     FicheroTXT:='';
end;

procedure TfImportar.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction:=CaFree;
end;

procedure TfImportar.FormCreate(Sender: TObject);
begin
 //--------- Conectar con la bbdd
  Conectate(dbConnect);

  pc.ActivePage:=tsSeleccion;
end;

procedure TfImportar.FormShow(Sender: TObject);
begin
 dsProcesados.DataSet:= dbPedid;
 if not (DirectoryExists(Lee+'selecciones')) then CreateDir(Lee+'selecciones')
end;

procedure TfImportar.MostrarPosicion(Sender: TObject);
begin
  ePos.Text:=IntToStr(SynEdit1.CaretX);
end;

initialization
  {$I importar.lrs}

end.

