#!/usr/bin/env python
################################################################################
#  Copyright (C) 2004  Travis Shirk <travis@pobox.com>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#  $Id: TagWidget.py,v 1.2 2004/05/14 04:18:27 travis Exp $
################################################################################
import sys;
from qt import *;
from TagWidgetBase import TagWidgetBase;
import eyeD3;

class TagWidget (TagWidgetBase):
    def __init__(self, parent = None, name = None):
        TagWidgetBase.__init__(self, parent, name);

        # Set input masks
        regex = QRegExp("^[1-9][0-9][0-9][0-9]$");
        yearValidator = QRegExpValidator(regex, self);
        self.yearEdit.setValidator(yearValidator);

        regex = QRegExp("^[0-9][0-9][0-9]$");
        trackValidator = QRegExpValidator(regex, self);
        self.trackTotalEdit.setValidator(trackValidator);

        # Fill genre combo box.
        genres = eyeD3.genres;
        genres.sort();
        self.genreCombo.insertItem("", 0);
        for g in genres: 
            if g == "Unknown":
                continue;
            self.genreCombo.insertItem(g);

        # ...and "enough" tracks.
        self.trackCombo.insertItem("");
        for i in range(1, 10):
            self.trackCombo.insertItem("0%d" % (i));
        for i in range(10, 1000):
            self.trackCombo.insertItem("%d" % (i));

        # Disable some tabs for now.
        self.tagTab.setTabEnabled(self.tagTab.page(2), 0);
        self.tagTab.setTabEnabled(self.tagTab.page(3), 0);

    def loadTag(self, tag):
        print "TagWidgetBase.loadTag(tag): Not implemented yet"

    def show(self):
        TagWidgetBase.show(self);
        mp3 = QFileDialog.getOpenFileName("/home/travis/src/devel/eyeD3",
                                          "MP3 Files (*.mp3)",
                                          self, "opendialog",
                                          "Choose an MP3 file");
        print "Selected: %s" % (mp3);

def main():
    a = QApplication(sys.argv);
    QApplication.setStyle(QPlatinumStyle());
    QObject.connect(a, SIGNAL("lastWindowClosed()"), a, SLOT("quit()"));
    tw = TagWidget();
    # Cancel quits.
    QObject.connect(tw.cancelButton, SIGNAL("clicked()"), a, SLOT("quit()"));
    a.setMainWidget(tw);
    tw.show();
    a.exec_loop();
    return 0;

if __name__ == "__main__":
   sys.exit(main());

