/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/**************************************************************
*
* file: mpi_kb.h
*
* contents: My own definitions in regard to MPI (copied from pvm_kb.h)
*/

#define MAXTIDS 1000
extern int self_ord; /* ordinal of self in tid array */
#define HOST_ORD -1

#define PVM_combiner_dadd  1
extern int typesize[10];  /* type sizes for combiners */ 

extern int count;  /* array size */
struct command { int cmd;  /* see defines */ 
                 int pernode; /* number of elements per node */
		 int count;  /* total elements */
		 int type ;  /* type of element */
		 int size;   /* size of element structure */
		 int mode;   /* type of quantity */
     };
/* commands */
#define ALLOC      1
#define DISTRIBUTE 2
#define NEWWEB     3
#define CALCQUANTS 4
#define NEWDYMEM   5
#define NEWTODO    6
#define CALCQUANTGRADS 7
#define FACET_KNOT_INIT 8
#define PVM_QUIT       9

/* special distribute type */
#define VERTEX_COORD 0x4567

/* message types */
#define PVM_REDUCE_MSG  1
#define PVM_BCHOST_MSG  2
#define PVM_BCHOSTV_MSG  3
#define PVM_DISTRIB_MSG  4

