/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

/**
 *	struct selwin - contains info a standard selection list window
 *	@dialog: contains common dialog window properties
 *	@clist: the choices/selection list
 *
 *	This structure maintains various information on the standard
 *	dialog window containing a selection list. The window offers
 *	a title, a subwindow for a selection list, column labels, a
 *	description for the user, and a "button bar" with a Help, Cancel,
 *	Previous, and Next button.
 */
struct selwin {
	struct dialog_window dialog;
	struct clist *clist;
};

inline void mark_selection(struct clist_item *item);
inline void unmark_selection(struct clist_item *item);
int row_selected(struct clist *clist, struct clist_item *item);
int row_unselected(struct clist *clist, struct clist_item *item);
struct selwin *create_selection_window(const char *title, const char *help_text,
					char *prompt, char *next_button_text,
					menuitem_activate_cb next_button_callback,
					char *prev_button_text,
					menuitem_activate_cb prev_button_callback,
					gpointer user_data);
int format_standard_item(object_handle_t handle, void *not_used, GPtrArray *text);
GSList *get_selected_handles(struct clist *clist);
engine_handle_t get_selected_handle(struct clist *clist);
void *get_selected_data(struct clist *clist);
struct selwin *create_list_dialog(char *title, const char *help_text, char *prompt,
					int columns, void *user_data);
