/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM Region Manager
 * File: evms2/engine/plugins/lvm/lvm_move.h
 */

/* Move-Extent functions. */
#define LVM_FUNCTION_MOVE_EXTENT	(EVMS_Task_Plugin_Function)
#define LVM_FUNCTION_MOVE_PV		(EVMS_Task_Plugin_Function + 2)

#define LVM_REGION_FUNCTION_COUNT		1
#define LVM_CONTAINER_FUNCTION_COUNT		1

/* Option for move-related tasks. */
#define LVM_OPTION_MOVE_EXTENT_LE_INDEX		0
#define LVM_OPTION_MOVE_EXTENT_LE_STR		"le"
#define LVM_OPTION_MOVE_EXTENT_PV_INDEX		1
#define LVM_OPTION_MOVE_EXTENT_PV_STR		"pv"
#define LVM_OPTION_MOVE_EXTENT_PE_INDEX		2
#define LVM_OPTION_MOVE_EXTENT_PE_STR		"pe"

#define LVM_OPTION_MOVE_PV_TARGET_LIST_IDX	0
#define LVM_OPTION_MOVE_PV_TARGET_LIST_STR	"target_pvs"
#define LVM_OPTION_MOVE_PV_MAINTAIN_STRIPES_IDX	1
#define LVM_OPTION_MOVE_PV_MAINTAIN_STRIPES_STR	"maintain_stripes"

#define MAINTAIN_STRIPES_OFF			0
#define MAINTAIN_STRIPES_LOOSE			1
#define MAINTAIN_STRIPES_STRICT			2

/* Functions exported from lvm_move.c */

extern int lvm_commit_move_extents(lvm_volume_group_t * group);

/* "Move-Extent" functions. */
extern int lvm_move_extent_init_task(task_context_t * context);
extern int lvm_move_extent_set_option(task_context_t * context,
				      u_int32_t index,
				      value_t * value,
				      task_effect_t * effect);
extern int lvm_move_extent(lvm_logical_volume_t * volume,
			   option_array_t * options);

/* "Move-PV" functions. */
extern int lvm_can_move_pv(lvm_physical_volume_t * source_pv,
			   lvm_physical_volume_t * target_pvs[],
			   int maintain_stripes);
extern int lvm_move_pv_init_task(task_context_t * context);
extern int lvm_move_pv_set_objects(task_context_t * context,
				   list_anchor_t declined_objects,
				   task_effect_t * effect);
extern int lvm_move_pv_set_option(task_context_t * context,
				  u_int32_t index,
				  value_t * value,
				  task_effect_t * effect);
extern int lvm_move_pv(lvm_volume_group_t * group,
		       list_anchor_t objects,
		       option_array_t * options);

