/***************************************************************************
 *   Copyright (C) 2005 by yunfan                                          *
 *   yunfan_zg@163.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/ 
#ifndef EVAMAINWINDOW_H
#define EVAMAINWINDOW_H

#include "evamainuibase.h"
#include <qpoint.h>
#include <qsize.h>
#include <qtooltip.h>
#include <list>
#include <string>
#include "evalistview.h"

class MainWindowTip : public QToolTip{
public:
	MainWindowTip(QWidget *parent);
	virtual ~MainWindowTip() {}
	
protected:
	void maybeTip(const QPoint &);
};

class QResizeEvent;
class QListViewItem;
class QPopupMenu;

class EvaMainWindow : public EvaMainUIBase
{
	Q_OBJECT
public:
	EvaMainWindow(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 ); // | WDestructiveClose
	~EvaMainWindow();
	
	void setMainInfo(const unsigned int id, const QString &nick, QPixmap *p);
	QRect tipRect(const QPoint &pos);
	QString myInfoTip();
	const unsigned int getQQ() const { return qqNum; }
	void setStatusPixmaps(QPixmap *online, QPixmap *offline, QPixmap *leave, QPixmap *invisble);
	void setSystemMenu( QPopupMenu *sys);
	void setStatusMenu( QPopupMenu *status);
	void setBasicPixmaps(QPixmap *sys, QPixmap *open, QPixmap *close, QPixmap *na, QPixmap *msg);
	void setGroupMenu(QPixmap *rename, QPixmap *newGroup, QPixmap *deleleGroup, 
			QPixmap *onlineBuddies, QPixmap *allBuddies, QPixmap *qun);
	void setBuddyMenu(QPixmap *chat, QPixmap *level, QPixmap * details, QPixmap *msgHistory, QPixmap *deleteBuddy);

	void setQunMenu(QPixmap *chat, QPixmap * details, QPixmap *msgHistory, QPixmap *qunExit);
	void setOrgsMenu();
	void setDiscussMenu();
	
	void setPosAndSize();
	const QPoint &getPosition() const { return nowPosition; }
	const QSize &getSize() const { return nowSize; }

	void changeGroupTo(const unsigned int id, const int index);	
	void addGroup(QString &name, const int index);
	void addBuddy(const QString &nick, const unsigned int id, const QString signature, const int index, 
			QPixmap *on, QPixmap *off, EvaBuddyItem::Status status = EvaBuddyItem::Offline);
	void updateNick(const unsigned int id, const QString &nick);
	void updateSignature(const unsigned int id, const QString &sig);
	void updateFacePixmaps(const unsigned int id, QPixmap *on, QPixmap *off);
	void addQun(QString &name, const unsigned int id, QPixmap *pic);
	void updateQun(QString &name, const unsigned int id, QPixmap *pic);
	
	void refreshFace(const QSize &size);
	void setFaceSize(const QSize &size);
	void clearList();
	void clearQunList();
	void updateAllGroupTitles();
public slots:
	void changeToOnline(unsigned int id);
	void changeToOffline(unsigned int id);
	void changeToLeave(unsigned int id);
	void changeToInvisible(unsigned int id);
	void newMessage(unsigned int id);
	void gotMessage(unsigned int id);
	void newQunMessage(unsigned int id);
	void gotQunMessage(unsigned int id);
	void slotShowOnlineBuddies();
	void slotShowAllBuddies();
	
	void deleteBuddy(unsigned int id);
	
	void online();
	void offline();
	void leave();
	void invisible();
signals:
	void groupDeleted(const int);  // paremeter is the group index
	void groupAdded(QString, int); // group name & index
	void groupRenamed(QString, int); // group name & index
	void deleteMeFrom(int);
	void groupChanged(unsigned int,int);
	void requestAddBuddy(const unsigned int);
	void showOnlineSelected();
	void showAllSelected();
	
	void requestChat(const unsigned int);
	void requestSendFile(const unsigned int);
	void requestLevel(const unsigned int);
	void requestDetails(const unsigned int);
	void requestModifyMemo(const unsigned int);
	void requestHistory(const unsigned int);
	void requestDelete(const unsigned int);  // the deleting qq number 
	void requestSearch();
	void requestSystemMessages();
	
	void requestQunChat(const unsigned int);
	void requestQunDetails(const unsigned int);
	void requestQunExit(const unsigned int);
	void requestQunCreate();
	void requestQunHistory(const unsigned int);
protected:
	void resizeEvent( QResizeEvent *event);
	void moveEvent( QMoveEvent *event );

private:
	QPoint  nowPosition;
	QSize   nowSize;
	unsigned int qqNum;
	QPopupMenu *groupMenu; 
	QPopupMenu *buddyMenu;
	QPopupMenu *qunMenu;
	QPopupMenu *qunOrgsMenu;
	QPopupMenu *qunDiscussMenu;
	QPopupMenu *sysMenu;
	QPopupMenu *statusMenu;
	
	QPixmap *pixOnline;
	QPixmap *pixOffline;
	QPixmap *pixLeave;
	QPixmap *pixInvisible;
	
	MainWindowTip *myTip;
private slots:
	void slotUpdateBuddyStat();
	void slotTbMyFace();
	void slotContextMenu(QListViewItem *, const QPoint & , int);

	void slotItemRenamed(QListViewItem *, int);
		
	void slotRenameGroup();
	void slotNewGroup();
	void slotDelGroup();
	
	void slotIMChat();
	void slotSendFile();
	void slotUpdataLevel();
	void slotDetails();
	void slotHistory();
	void slotDelBuddy();
	
	void slotBuddyDoubleClick(QListViewItem *, const QPoint & , int);
	void slotListViewClicked(QListViewItem *);
	
	void slotSearch();
	void slotSystemMessages();
	
	void slotIMQunChat();
	void slotQunDetails();
	void slotQunExit();
	void slotQunCreate();
	void slotQunHistory();

	void slotModifyMemo();
};

#endif
