/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-thread-manager-types.h,v 1.18 2004/12/12 12:38:57 hoa Exp $
 */

#ifndef ETPAN_THREAD_MANAGER_TYPES_H

#define ETPAN_THREAD_MANAGER_TYPES_H

#include <libetpan/libetpan.h>
#include <semaphore.h>
#include <pthread.h>
#include <sys/types.h>
#include <inttypes.h>
#include "etpan-msg-params-types.h"
#include "etpan-cfg-sender-types.h"

enum {
  ETPAN_THREAD_END,

  ETPAN_THREAD_FOLDER_GET_MSG_LIST,
  ETPAN_THREAD_FOLDER_FREE_MSG_LIST,
  ETPAN_THREAD_FOLDER_CHECK,
  ETPAN_THREAD_FOLDER_STATUS,
  ETPAN_THREAD_FOLDER_EXPUNGE,
  
  ETPAN_THREAD_MESSAGE_GET_BODYSTRUCTURE,
  ETPAN_THREAD_MESSAGE_CHECK,
  ETPAN_THREAD_MESSAGE_FLUSH,
  ETPAN_THREAD_MESSAGE_FETCH,
  ETPAN_THREAD_MESSAGE_FETCH_HEADER,
  ETPAN_THREAD_MESSAGE_FETCH_SECTION,
  ETPAN_THREAD_MESSAGE_FETCH_SECTION_MIME,
  ETPAN_THREAD_MESSAGE_FETCH_SECTION_HEADER,
  ETPAN_THREAD_MESSAGE_FETCH_RESULT_FREE,
  
  ETPAN_THREAD_FOLDER_APPEND_MESSAGE,
#if 0
  ETPAN_THREAD_MESSAGE_SEND,
#endif
  
  ETPAN_THREAD_MESSAGE_RENDER_MIME,
  ETPAN_THREAD_MESSAGE_RENDER_REPLY_MIME,
  ETPAN_THREAD_MESSAGE_MIME_COPY,

  ETPAN_THREAD_MSGLIST_CHECK,
  ETPAN_THREAD_MSGLIST_COPY,
  ETPAN_THREAD_MSGLIST_MOVE,
  
  ETPAN_THREAD_MSGLIST_SPAM,
  
  ETPAN_THREAD_MESSAGE_REF,
  ETPAN_THREAD_MESSAGE_UNREF,

  ETPAN_THREAD_NNTP_LIST_GROUPS,
  ETPAN_THREAD_IMAP_LIST_MAILBOXES,
  ETPAN_THREAD_IMAP_SELECT,
  ETPAN_THREAD_IMAP_CREATE,

  ETPAN_THREAD_DONE_CONFIG,
  ETPAN_THREAD_STOP_STORAGE_THREAD,

  ETPAN_THREAD_STORAGE_DISCONNECT,
  
  ETPAN_THREAD_ABOOK_LOOKUP,
  ETPAN_THREAD_ABOOK_DISCONNECT,
  
  ETPAN_THREAD_SENDER_SENDMAIL,
  
  ETPAN_THREAD_DISCOVER_FOLDER,
};


struct etpan_folder_status_result {
  uint32_t number;
  uint32_t recent;
  uint32_t unseen;
};

struct etpan_folder_get_msg_list_arg {
  chash * node_params;
};

struct etpan_folder_get_msg_list_result {
  struct mailmessage_tree * env_tree;
  struct etpan_node_msg_params * node_params;
};

struct etpan_message_fetch_result {
  char * content;
  size_t len;
};

struct etpan_message_render_result {
  char * filename;
  FILE * f;
  carray * attr;
};

struct etpan_message_render_reply_result {
  struct mailmime * mime;
  struct mailmime * edit_part;
  int edit_part_line;
};

/*
  result of nntp_list_groups is a carray of (struct etpan_nntp_group_info *)
  arg is a string separated with ',' of newsgroups filters
*/

/*
  result of imap_list_groups is a carray of (struct etpan_imap_mailbox_info *)
  arg is a wildcard
*/

struct etpan_folder_free_msg_list_arg {
  struct mailmessage_tree * env_tree;
  struct etpan_node_msg_params * node_params;
};

struct etpan_msglist_check_arg {
  carray * msglist;
};

struct etpan_msglist_copy_arg {
  carray * msglist;
  struct mailfolder * folder;
};

struct etpan_msglist_move_arg {
  carray * msglist;
  struct mailfolder * folder;
};

enum {
  ETPAN_THREAD_SPAM,
  ETPAN_THREAD_NON_SPAM,
  ETPAN_THREAD_FIX_SPAM,
  ETPAN_THREAD_FIX_NON_SPAM,
};

struct etpan_msglist_spam_arg {
  carray * msglist;
  int spam_type;
};

enum {
  ETPAN_THREAD_REPLY,
  ETPAN_THREAD_REPLY_ALL,
  ETPAN_THREAD_REPLY_FOLLOWUP_TO,
  ETPAN_THREAD_REPLY_FORWARD,
  ETPAN_THREAD_REPLY_FORWARD_AS_ATTACHMENT,
};

struct etpan_message_render_reply_arg {
  int reply_type;
  struct etpan_account_info * account;
  struct mailimf_address_list * dest_addr;
  struct mailfolder * post_folder;
};


struct etpan_message_mime_copy_result {
  struct mailmime * mime;
};

struct etpan_thread_op_mailaccess {
  struct mailstorage * storage;
  struct mailfolder * folder;
  mailmessage * msg;
  struct mailmime * mime;
};

struct etpan_thread_op_abook {
  struct etpan_abook * abook;
};

struct etpan_thread_op_sender {
  struct etpan_sender_item * sender;
};

struct etpan_thread_op {
  union {
    struct etpan_thread_op_mailaccess mailaccess;
    struct etpan_thread_op_abook abook;
    struct etpan_thread_op_sender sender;
  } data;
  
  int cmd;
  
  void * arg;
  void * result;
  int err;
  
  int state;
  pthread_mutex_t state_lock;

  struct etpan_thread_data * thread_data;
};

enum {
  ETPAN_THREAD_TYPE_MISC,
  ETPAN_THREAD_TYPE_LOCAL_MAILACCESS,
  ETPAN_THREAD_TYPE_REMOTE_MAILACCESS,
  ETPAN_THREAD_TYPE_REMOTE_ABOOK,
  ETPAN_THREAD_TYPE_SENDER,
};

struct etpan_thread_data {
  int thread_index;
  int type;
  struct etpan_thread_manager * manager;
  
  pthread_mutex_t run_lock;
  
  pthread_t th_id;
  
  int sem_type;
  sem_t * sem;
  pthread_mutex_t lock;
  carray * op_list;
  
  int fd[2];
};


#define ETPAN_LOCALSTORAGE_THREAD_COUNT 2

struct etpan_local_mailaccess_info {
  struct mailstorage * storage;
  struct etpan_thread_data * thread_data;
  int op_count;
};

struct etpan_thread_manager {
  struct etpan_app * app;
  /* key : storage, value : etpan_thread_data */
  struct mailengine * engine;
  
  pthread_mutex_t last_thread_index_lock;
  int last_thread_index;
  
  pthread_mutex_t thread_hash_lock;
  
  /* key : thread index => value : thread data */
  chash * thread_hash;
  
  struct etpan_thread_data * thread_misc;
  /* key : storage => value : thread data */
  chash * thread_local_mailaccess;
  /* thread index, counts */
  struct etpan_thread_data *
    thread_tab_local_mailaccess[ETPAN_LOCALSTORAGE_THREAD_COUNT];
  int thread_local_mailaccess_count[ETPAN_LOCALSTORAGE_THREAD_COUNT];
  /* key : storage => value : thread data */
  chash * thread_remote_mailaccess;
  /* key : abook => value : thread index */
  chash * thread_remote_abook;
  /* key : sender => value : thread index */
  chash * thread_sender;
};

#endif
