/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-app-types.h,v 1.14 2004/08/22 16:27:37 hoa Exp $
 */

#ifndef ETPAN_APP_TYPES_H

#define ETPAN_APP_TYPES_H

#include "etpan-config-types.h"
#include "etpan-subapp-types.h"
#include "etpan-thread-manager-types.h"
#include <pthread.h>
#include <sys/types.h>
#include <libetpan/libetpan.h>

#define ETPAN_MAX_COLORS 64

struct etpan_app {
  char config_path[PATH_MAX];
  pid_t pid;
  
  /* config */
  struct etpan_app_config config;
  
#if 0
  /* key bindings */
  struct etpan_key_config * folder_list_key_config;
  struct etpan_key_config * msg_list_key_config;
  struct etpan_key_config * msg_view_key_config;
  struct etpan_key_config * mime_view_key_config;
#endif

  /* thread manager */
  struct etpan_thread_manager * thread_manager;
  
  /* privacy manager */
  struct mailprivacy * privacy;
  
  /* quit application */
  pthread_mutex_t end_lock;
  int end;

  /* console */
  struct etpan_subapp * console;
  pthread_mutex_t log_lock;

  /* subapp info */
  struct etpan_subapp * current_subapp;
  carray * subapp_list;
  carray * zorder;
  carray * switch_order;
  
  /* display info */
  int width;
  int height;
  int color_available_tab[ETPAN_MAX_COLORS];
  chash * color_pairs_hash;
  int color_enabled;
  
  char * fill;
  char * buffer;
  char * output;
  int buf_len;
  
  int title_attr;
  int sel_title_attr;
};

#endif

