/*************************************************************************************************
 * Interface of features of dynamic linking functions
 *                                                      Copyright (C) 2003-2005 Mikio Hirabayashi
 * This file is part of Estraier, a personal full-text search system.
 * Estraier is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the
 * License, or any later version.
 * Estraier is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with Estraier;
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA.
 *************************************************************************************************/


#ifndef _ESTDLFUNC_H                     /* duplication check */
#define _ESTDLFUNC_H



/*************************************************************************************************
 * functions
 *************************************************************************************************/


/* Get the pointer of a function in a dynamic linking library.
   `file' specifies the name of a dynamic linking library.
   `symbol' specifies the name of a function.
   The return value is the pointer to the function or NULL on failure. */
extern ESTFILTER (*estgetdlfunc)(const char *file, const char *symbol);



#endif                                   /* duplication check */


/* END OF FILE */
