/* +++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* .COPYRIGHT   (C) 1993-2005 European Southern Observatory     */
/* .IDENT       nrutil.c                                   */
/* .AUTHORS     Pascal Ballester (ESO/Garching)            */
/*              Cristian Levin   (ESO/La Silla)            */
/* .KEYWORDS    Spectroscopy, Long-Slit                    */
/* .PURPOSE                                                */
/* .VERSION     1.0  Package Creation  17-MAR-1993  

051021		last modif			           */
/* ------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>

#ifdef __STDC__ 
 void nrerror( char error_text[])
#else
 void nrerror(error_text)
 char error_text[];
#endif

{

#ifdef __STDC__
        void exit(int);
#endif

	fprintf(stderr,"Numerical Recipes run-time error...\n");
	fprintf(stderr,"%s\n",error_text);
	fprintf(stderr,"...now exiting to system...\n");
	exit(1);
}

/* functions of the OSMEMORY module of the Midas system library */
#ifdef __STDC__
   char *osmmget(unsigned int);
   void osmmfree(char *);
#else
   char *osmmget();
   void osmmfree();
#endif

#ifdef __STDC__
  int **imatrix( int nrl, int nrh, int ncl, int nch ) 
#else
  int **imatrix( nrl, nrh, ncl, nch ) 
  int nrl, nrh, ncl, nch;
#endif
/* Allocates a int matrix with range [nrl..nrh][ncl..nch] */
{
    int i;
    int **m;

    /* Allocate pointers to rows */
    m = (int **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(int *) );
    m -= nrl;

    /* Allocate rows and set pointers to them */
    for ( i = nrl; i <= nrh; i++ ) {
	m[i] = (int *)osmmget( (unsigned) (nch-ncl+1) * sizeof(int) );
        m[i] -= ncl;
    }
}

/* #ifdef __STDC__
  void free_imatrix( int **m, int nrl, int nrh, int ncl, int nch ) 
#else
  void free_imatrix( m, nrl, nrh, ncl, nch ) 
  int **m,nrl,nrh,ncl,nch;
#endif */
#ifdef __STDC__
  void free_imatrix( int **m, int nrl, int nrh, int ncl ) 
#else
  void free_imatrix( m, nrl, nrh, ncl ) 
  int **m,nrl,nrh,ncl;
#endif 
/* Frees a matrix allocated with imatrix() */

{
    int i;

    for ( i = nrh; i >= nrl; i-- )
	osmmfree( (char *) (m[i] + ncl) );

    osmmfree( (char *) (m + nrl) );
}

#ifdef __STDC__
  int *ivector( int nl, int nh ) 
#else
  int *ivector( nl, nh ) 
  int nl, nh;
#endif
/* Allocates a int vector with range [nl..nh] */
{
    int *v;

    v = (int *)osmmget( (unsigned) (nh-nl+1) * sizeof(int) );
    return( v - nl );
}

/* #ifdef __STDC__
  void free_ivector( int *v, int nl, int nh ) 
#else
  void free_ivector( v, nl, nh ) 
  int *v,nl,nh;
#endif */
#ifdef __STDC__
  void free_ivector( int *v, int nl ) 
#else
  void free_ivector( v, nl ) 
  int *v,nl;
#endif
/* Frees a vector allocated with ivector() */
{
    osmmfree( (char *) (v + nl) );
}


#ifdef __STDC__
  double **dmatrix( int nrl, int nrh, int ncl, int nch ) 
#else
  double **dmatrix( nrl, nrh, ncl, nch ) 
  int nrl, nrh,ncl,nch;
#endif
/* Allocates a double matrix with range [nrl..nrh][ncl..nch] */
{
    int i;
    double **m;

    /* Allocate pointers to rows */
    m = (double **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(double *) );
    m -= nrl;

    /* Allocate rows and set pointers to them */
    for ( i = nrl; i <= nrh; i++ ) {
	m[i] = (double *)osmmget( (unsigned) (nch-ncl+1) * sizeof(double) );
        m[i] -= ncl;
    }
    return( m );
}

/* #ifdef __STDC__
   void free_dmatrix( double **m, int nrl, int nrh, int ncl, int nch ) 
#else
   void free_dmatrix( m, nrl, nrh, ncl, nch ) 
   double **m;
   int nrl,nrh,ncl,nch;
#endif */
#ifdef __STDC__
   void free_dmatrix( double **m, int nrl, int nrh, int ncl ) 
#else
   void free_dmatrix( m, nrl, nrh, ncl ) 
   double **m;
   int nrl,nrh,ncl;
#endif
/* Frees a matrix allocated with dmatrix() */
{
    int i;

    for ( i = nrh; i >= nrl; i-- )
	osmmfree( (char *) (m[i] + ncl) );

    osmmfree( (char *) (m + nrl) );
}

#ifdef __STDC__
  double *dvector( int nl, int nh ) 
#else
  double *dvector( nl, nh ) 
  int nl, nh;
#endif
/* Allocates a double vector with range [nl..nh] */
{
    double *v;

    v = (double *)osmmget( (unsigned) (nh-nl+1) * sizeof(double) );
    return( v - nl );
}

#ifdef __STDC__
  void free_dvector( double *v, int nl, int nh ) 
#else
  void free_dvector( v, nl, nh ) 
  double *v;
  int nl, nh;
#endif
/* Frees a vector allocated with dvector() */
{
    osmmfree( (char *) (v + nl) );
}


#ifdef __STDC__
  float **fmatrix( int nrl, int nrh, int ncl, int nch ) 
#else
  float **fmatrix( nrl, nrh, ncl, nch ) 
  int nrl,nrh,ncl,nch;
#endif
/* Allocates a float matrix with range [nrl..nrh][ncl..nch] */
{
    int i;
    float **m;

    /* Allocate pointers to rows */
    m = (float **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(float *) );
    m -= nrl;

    /* Allocate rows and set pointers to them */
    for ( i = nrl; i <= nrh; i++ ) {
	m[i] = (float *)osmmget( (unsigned) (nch-ncl+1) * sizeof(float) );
        m[i] -= ncl;
    }
    return( m );
}

#ifdef __STDC__
  void free_fmatrix( float **m, int nrl, int nrh, int ncl, int nch ) 
#else
  void free_fmatrix( m, nrl, nrh, ncl, nch ) 
  float **m;
  int nrl,nrh,ncl,nch;
#endif
/* Frees a matrix allocated with fmatrix() */
{
    int i;

    for ( i = nrh; i >= nrl; i-- )
	osmmfree( (char *) (m[i] + ncl) );

    osmmfree( (char *) (m + nrl) );
}


#ifdef __STDC__
  float *fvector( int nl, int nh ) 
#else
  float *fvector( nl, nh ) 
  int nl,nh;
#endif
/* Allocates a float vector with range [nl..nh] */
{
    float *v;

    v = (float *)osmmget( (unsigned) (nh-nl+1) * sizeof(float) );
    return( v - nl );
}


#ifdef __STDC__
  void free_fvector( float *v, int nl, int nh ) 
#else
  void free_fvector( v, nl, nh ) 
  float *v;
  int nl,nh;
#endif
/* Frees a vector allocated with fvector() */
{
    osmmfree( (char *) (v + nl) );
}

#ifdef __STDC__
  char **cmatrix( int nrl, int nrh, int ncl, int nch ) 
#else
  char **cmatrix( nrl, nrh, ncl, nch ) 
  int nrl,nrh,ncl,nch;
#endif
/* Allocates a char matrix with range [nrl..nrh][ncl..nch] */
{
    int i;
    char **m;

    /* Allocate pointers to rows */
    m = (char **)osmmget( (unsigned) (nrh-nrl+1) * sizeof(char *) );
    m -= nrl;

    /* Allocate rows and set pointers to them */
    for ( i = nrl; i <= nrh; i++ ) {
	m[i] = (char *)osmmget( (unsigned) (nch-ncl+1) * sizeof(char) );
        m[i] -= ncl;
    }
    return( m );
}

#ifdef __STDC__
  void free_cmatrix( char **m, int nrl, int nrh, int ncl, int nch ) 
#else
  void free_cmatrix( m, nrl, nrh, ncl, nch ) 
  char **m;
  int nrl,nrh,ncl,nch;
#endif
/* Frees a matrix allocated with cmatrix() */
{
    int i;

    for ( i = nrh; i >= nrl; i-- )
	osmmfree( (char *) (m[i] + ncl) );

    osmmfree( (char *) (m + nrl) );
}

#ifdef __STDC__
  char *cvector( int nl, int nh ) 
#else
  char *cvector( nl, nh ) 
  int nl,nh;
#endif
/* Allocates a char vector with range [nl..nh] */
{
    char *v;

    v = (char *)osmmget( (unsigned) (nh-nl+1) * sizeof(char) );
    return( v - nl );
}

#ifdef __STDC__
  void free_cvector( char *v, int nl, int nh ) 
#else
  void free_cvector( v, nl, nh ) 
  char *v;
  int nl,nh;
#endif
/* Frees a vector allocated with cvector() */
{
    osmmfree( (char *) (v + nl) );
}


#ifdef __STDC__
  float *vector(int nl, int nh)
#else
  float *vector(nl, nh)
  int nl, nh;
#endif

{
	float *v;

	v=(float *)malloc((size_t) (nh-nl+1)*sizeof(float));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}



#ifdef __STDC__
void free_vector( float *v, int nl, int nh)
#else
void free_vector(v,nl,nh)
int *v,nl,nh;
#endif

{
	osmmfree((char*) (v+nl));
}

#ifdef __STDC__
  float **matrix(int nrl, int nrh, int ncl, int nch)
#else
  float **matrix(nrl, nrh, ncl, nch)
  int nrl, nrh, ncl, nch;
#endif

{
	int i;
	float **m;

	m=(float **) malloc((size_t) (nrh-nrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(float *) malloc((size_t) (nch-ncl+1)*sizeof(float));
		if (!m[i]) nrerror("allocation failure 2 in matrix()");
		m[i] -= ncl;
	}
	return m;
}

#ifdef __STDC__
void free_matrix(float **m, int nrl, int nrh, int ncl, int nch)
#else
void free_matrix(m,nrl,nrh,ncl,nch)
float **m;
int nrl,nrh,ncl,nch;
#endif

{
	int i;

	for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	free((char*) (m+nrl));
}

#ifdef __STDC__
float **submatrix( float **a, int oldrl, int oldrh, int oldcl,
                   int oldch, int newrl, int newcl)
#else
float **submatrix(a,oldrl,oldrh,oldcl,oldch,newrl,newcl)
float **a;
int oldrl,oldrh,oldcl,oldch,newrl,newcl;
#endif

{
	int i,j;
	float **m;

	m=(float **) malloc((size_t) (oldrh-oldrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure in submatrix()");
	m -= newrl;

	for(i=oldrl,j=newrl;i<=oldrh;i++,j++) m[j]=a[i]+oldcl-newcl;

	return m;
}

#ifdef __STDC__
void free_submatrix(float **b, int nrl, int nrh, int ncl, int nch)
#else
void free_submatrix(b,nrl,nrh,ncl,nch)
float **b;
int nrl,nrh,ncl,nch;
#endif

{
	osmmfree((char*) (b+nrl));
}

#ifdef __STDC__
float **convert_matrix( float *a, int nrl, int nrh, int ncl, int nch)
#else
float **convert_matrix(a,nrl,nrh,ncl,nch)
float *a;
int nrl,nrh,ncl,nch;
#endif

{
	int i,j,nrow,ncol;
	float **m;

	nrow=nrh-nrl+1;
	ncol=nch-ncl+1;
	m = (float **) malloc((size_t) (nrow)*sizeof(float*));
	if (!m) nrerror("allocation failure in convert_matrix()");
	m -= nrl;
	for(i=0,j=nrl;i<=nrow-1;i++,j++) m[j]=a+ncol*i-ncl;
	return m;
}

#ifdef __STDC__
void free_convert_matrix(float **b, int nrl, int nrh, int ncl, int nch)
#else
void free_convert_matrix(b,nrl,nrh,ncl,nch)
float **b;
int nrl,nrh,ncl,nch;
#endif

{
	osmmfree((char*) (b+nrl));
}
