/* @(#)nrutil.h	19.1 (ESO-IPG) 02/25/03 14:19:15 */

/**********************************************************
* Error handling and memory allocation utilities
* Include file from numrec.c
*
* Edition History
*
* 06.05.93  initial test version             B.Schulz
* 04.02.98  wrong declarations!
*           change vector -> dvector, fvector -> vector
*           change matrix -> dmatrix, fmatrix -> matrix
*                                            S.Wolf (swolf@eso.org)
*
************************************************************/


/*==================================================
  Standard error handler for numerical recipes
==================================================*/

void nrerror();

/*==================================================
 Standard error handler
==================================================*/

void xerror();


/*==================================================
   Allocates a double vector with range [nl..nh]
==================================================*/

double *dvector();


/*==================================================
  Frees a double vector allocated by dvector()
==================================================*/

void free_dvector();


/*==================================================
   Allocates a float vector with range [nl..nh]
==================================================*/

float *vector();


/*==================================================
  Frees a float vector allocated by vector()
==================================================*/

void free_vector();


/*==================================================
   Allocates an int vector with range [nl..nh]
==================================================*/

int *ivector();


/*==================================================
  Frees an int vector allocated by ivector()
==================================================*/

void free_ivector();


/*==================================================
   Allocates an short int vector with range [nl..nh]
==================================================*/

short int *sivector();


/*==================================================
  Frees an short int vector allocated by ivector()
==================================================*/

void free_sivector();


/*==================================================
   Allocates a double matrix
   with range [nrl..nrh][ncl..nch]
==================================================*/

double **dmatrix();


/*==================================================
   Frees a matrix allocated with dmatrix
==================================================*/

void free_dmatrix();


/*==================================================
   Allocates a float matrix
   with range [nrl..nrh][ncl..nch]
==================================================*/

float **matrix();

/*==================================================
   Frees a float matrix allocated with matrix
==================================================*/

void free_matrix();


/*==================================================
   Allocates an int matrix
   with range [nrl..nrh][ncl..nch]
==================================================*/
int **imatrix();



/*==================================================
   Frees a matrix allocated with imatrix
==================================================*/

void free_imatrix();


/* EOF */
