# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the login data for a VCS system.
"""

from qt import *

from LoginForm import vcsLoginForm
from Config import ConfigVcsAuthSystems

class vcsLoginDialog(vcsLoginForm):
    """
    Class implementing a dialog to enter the login data for a VCS system.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        vcsLoginForm.__init__(self, parent, None, 1)
        
        vcsSystems = QStringList()
        for vcssys in ConfigVcsAuthSystems:
            vcsSystems.append(vcssys)
        self.vcsComboBox.insertStringList(vcsSystems)
        
        dummy = self.trUtf8('dummy')
        
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a tuple of 5 strings (vcs system, username,
            password, remote hostname and repository).
        """
        return (str(self.vcsComboBox.currentText()),
            str(self.usernameEdit.text()),
            str(self.passwordEdit.text()),
            str(self.hostEdit.text()),
            str(self.repositoryEdit.text())
        )
