# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the VCS command options dialog.
"""

import string
import sys

from qt import *

from CommandOptionsForm import vcsCommandOptionsForm
import Utilities

class vcsCommandOptionsDialog(vcsCommandOptionsForm):
    """
    Class implementing the VCS command options dialog.
    """
    def __init__(self, vcs, parent=None):
        """
        Constructor
        
        @param vcs reference to the vcs object
        @param parent parent widget (QWidget)
        """
        vcsCommandOptionsForm.__init__(self, parent, None, 1)
        
        dummy = self.trUtf8('dummy')
        
        if sys.platform == "win32":
            self.optionChars = ['-', '/']
        else:
            self.optionChars = ['-']
        
        opt = vcs.vcsGetOptions()
        self.globalEdit.setText(string.join(opt['global']))
        self.commitEdit.setText(string.join(opt['commit']))
        self.checkoutEdit.setText(string.join(opt['checkout']))
        self.updateEdit.setText(string.join(opt['update']))
        self.addEdit.setText(string.join(opt['add']))
        self.removeEdit.setText(string.join(opt['remove']))
        self.diffEdit.setText(string.join(opt['diff']))
        self.logEdit.setText(string.join(opt['log']))
        self.historyEdit.setText(string.join(opt['history']))
        self.statusEdit.setText(string.join(opt['status']))
        self.tagEdit.setText(string.join(opt['tag']))
        self.exportEdit.setText(string.join(opt['export']))
        
    def getOptions(self):
        """
        Public method used to retrieve the entered options.
        
        @return dictionary of strings giving the options for each supported vcs command
        """
        opt = {}
        opt['global'] = Utilities.parseOptionString(self.globalEdit.text())
        opt['commit'] = Utilities.parseOptionString(self.commitEdit.text())
        opt['checkout'] = Utilities.parseOptionString(self.checkoutEdit.text())
        opt['update'] = Utilities.parseOptionString(self.updateEdit.text())
        opt['add'] = Utilities.parseOptionString(self.addEdit.text())
        opt['remove'] = Utilities.parseOptionString(self.removeEdit.text())
        opt['diff'] = Utilities.parseOptionString(self.diffEdit.text())
        opt['log'] = Utilities.parseOptionString(self.logEdit.text())
        opt['history'] = Utilities.parseOptionString(self.historyEdit.text())
        opt['status'] = Utilities.parseOptionString(self.statusEdit.text())
        opt['tag'] = Utilities.parseOptionString(self.tagEdit.text())
        opt['export'] = Utilities.parseOptionString(self.exportEdit.text())
        return opt

