# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the lexer base class.
"""

from qt import QString

class Lexer:
    """ 
    Subclass to implement the lexer base class.
    """
    def __init__(self):
        """
        Constructor
        """
        self.commentString = QString('')
        self.streamCommentString = {
            'start' : QString(''),
            'end' : QString('')
        }
        self.boxCommentString = {
            'start' : QString(''),
            'middle' : QString(''),
            'end' : QString('')
        }
            
    def commentStr(self):
        """
        Public method to return the comment string.
        
        @return comment string (QString)
        """
        return self.commentString
        
    def canBlockComment(self):
        """
        Public method to determine, whether the lexer language supports a block comment.
        
        @return flag (boolean)
        """
        return not self.commentString.isEmpty()
        
    def streamCommentStr(self):
        """
        Public method to return the stream comment strings.
        
        @return stream comment strings (dictionary with two QStrings)
        """
        return self.streamCommentString
        
    def canStreamComment(self):
        """
        Public method to determine, whether the lexer language supports a stream comment.
        
        @return flag (boolean)
        """
        return \
            (not self.streamCommentString['start'].isEmpty()) and \
            (not self.streamCommentString['end'].isEmpty())
        
    def boxCommentStr(self):
        """
        Public method to return the box comment strings.
        
        @return box comment strings (dictionary with three QStrings)
        """
        return self.boxCommentString
        
    def canBoxComment(self):
        """
        Public method to determine, whether the lexer language supports a box comment.
        
        @return flag (boolean)
        """
        return \
            (not self.boxCommentString['start'].isEmpty()) and \
            (not self.boxCommentString['middle'].isEmpty()) and \
            (not self.boxCommentString['end'].isEmpty())
