# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Goto dialog.
"""

from qt import *

from GotoForm import GotoForm

class GotoDialog(GotoForm):
    """
    Class implementing the Goto dialog.
    """
    def __init__(self,parent,name=None,modal=0,fl=0):
        """
        Constructor
        
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag indicating a modal dialog
        @param fl window flags
        """
        GotoForm.__init__(self,parent,name,modal,fl)
        
        dummy = self.trUtf8('dummy')
        
    def getLinenumber(self):
        """
        Public method to retrieve the linenumber.
        
        @return line number (int)
        """
        return self.linenumberSpinBox.value()
        
    def setMaxValue(self, lines):
        """
        Public method to set the highest selectable linenumber.
        
        @param lines max. number of lines of the editor
        """
        self.linenumberSpinBox.setMaxValue(lines)
