# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to add a new language to the project.
"""

from qt import *

from AddLanguageForm import AddLanguageForm

class AddLanguageDialog(AddLanguageForm):
    """
    Class implementing a dialog to add a new language to the project.
    """
    def __init__(self, parent = None,name = None):
        """
        Constructor
        
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        """
        AddLanguageForm.__init__(self,parent,name,1)
        
        dummy = self.trUtf8('dummy')
        
    def getSelectedLanguage(self):
        """
        Public method to retrieve the selected language.
        
        @return the selected language (QString)
        """
        return self.languageCombo.currentText()
