# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to add a file to the project.
"""

import os

from qt import *

from AddFileForm import AddFileForm

class AddFileDialog(AddFileForm):
    """
    Class implementing a dialog to add a file to the project.
    """
    def __init__(self,pro,parent = None,filter = None, name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param pro reference to the project object
        @param parent parent widget of this dialog (QWidget)
        @param filter filter specification for the file to add (string or QString)
        @param name name of this dialog (string or QString)
        @param modal flag for a modal dialog (boolean)
        @param fl window flags
        """
        AddFileForm.__init__(self,parent,name,1,fl)
        
        self.targetDirEdit.setText(pro.ppath)
        self.filter = filter
        self.ppath = pro.ppath
        
    def handleDirDialog(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = QFileDialog.getExistingDirectory(self.targetDirEdit.text(),
            self, None, self.trUtf8("Select target directory"), 1)
            
        if not directory.isNull():
            self.targetDirEdit.setText(QDir.convertSeparators(directory))
            
    def handleFileDialog(self):
        """
        Private slot to display a file selection dialog.
        """
        dir = self.sourceFileEdit.text()
        if dir.isEmpty():
            dir = self.targetDirEdit.text()
        if self.filter is None:
            dfilter = self.trUtf8(\
            "Python Files (*.py);;Qt User-Interface Files (*.ui);;"
            "Interface Files (*.idl);;Quixote PTL Files (*.ptl)")
        elif self.filter == 'ui':
            dfilter = self.trUtf8("Qt User-Interface Files (*.ui)")
        elif self.filter == 'py':
            dfilter = self.trUtf8("Python Files (*.py);;"
            "Quixote PTL Files (*.ptl);;All Files (*)")
        elif self.filter == 'idl':
            dfilter = self.trUtf8("Interface Files (*.idl)")
        else:
            return
        fn = QFileDialog.getOpenFileName(dir,
            dfilter,
            self, None, self.trUtf8("Select source file"))
            
        if not fn.isNull():
            self.sourceFileEdit.setText(QDir.convertSeparators(fn))
            
    def handleSTextChanged(self, sfile):
        """
        Private slot to handle the source dir text changed.
        
        If the entered source directory is a subdirectory of the current
        projects main directory, the target directory path is synchronized.
        It is assumed, that the user wants to add a bunch of files to
        the project in place.
        
        @param sfile the text of the source file line edit
        """
        if sfile.startsWith(self.ppath):
            dir = os.path.dirname(str(sfile))
            self.targetDirEdit.setText(dir)
        
    def getData(self):
        """
        Public slot to retrieve the dialogs data.
        
        @return tuple of two values (string string) giving the source file and
            the target directory
        """
        return (str(self.sourceFileEdit.text()), 
            str(self.targetDirEdit.text()))
