# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the exceptions filter dialog.
"""

from qt import *

from ExceptionsFilterForm import ExceptionsFilterForm

class ExceptionsFilterDialog(ExceptionsFilterForm):
    """
    Class implementing the exceptions filter dialog.
    """
    def __init__(self, excList, parent=None):
        """
        Constructor
        
        @param excList list of exceptions to be edited (list of strings)
        @param parent the parent widget (QWidget)
        """
        ExceptionsFilterForm.__init__(self, parent, None, 1)
        
        for exc in excList:
            self.exceptionListBox.insertItem(exc)
        
    def handleDelete(self):
        """
        Private slot to delete the currently selected exception of the listbox.
        """
        self.exceptionListBox.removeItem(self.exceptionListBox.currentItem())

    def handleAdd(self):
        """
        Private slot to handle the Add button press.
        """
        exception = self.exceptionEdit.text()
        if not exception.isEmpty():
            self.exceptionListBox.insertItem(exception)
            self.exceptionEdit.clear()
        
    def handleTextChanged(self, txt):
        """
        Private slot to handle the textChanged signal of exceptionEdit.
        
        This slot sets the enabled status of the add button and sets the forms
        default button.
        
        @param txt the text entered into exceptionEdit (QString)
        """
        if txt.isEmpty():
            self.okButton.setDefault(1)
            self.addButton.setDefault(0)
            self.addButton.setEnabled(0)
        else:
            self.okButton.setDefault(0)
            self.addButton.setDefault(1)
            self.addButton.setEnabled(1)
        
    def getExceptionsList(self):
        """
        Public method to retrieve the list of exception types.
        
        @return list of exception types (list of strings)
        """
        excList = []
        itm = self.exceptionListBox.firstItem()
        while itm is not None:
            excList.append(str(itm.text()))
            itm = itm.next()
        return excList
