# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2005 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter options used to start a project in the VCS.
"""

import os

from qt import *

from KdeQt import KQFileDialog

from OptionsForm import CvsOptionsForm

class CvsOptionsDialog(CvsOptionsForm):
    """
    Class implementing a dialog to enter options used to start a project in the repository.
    """
    def __init__(self, project, archiveName, archiveEditable=0, parent=None):
        """
        Constructor
        
        @param project reference to the project object
        @param archiveName name of the archive (string or QString)
        @param archiveEditable flag indicating that the archives name may be changed
                (boolean)
        @param parent parent widget (QWidget)
        """
        CvsOptionsForm.__init__(self, parent, None, 1)
        
        self.project = project
        
        hd = QDir.convertSeparators(QDir.homeDirPath())
        hd = os.path.join(unicode(hd), 'cvsroot')
        self.vcsDirectoryEdit.setText(hd)
        
        self.vcsArchiveEdit.setText(archiveName)
        self.vcsArchiveEdit.setReadOnly(not archiveEditable)
        
        self.vcsVendorEdit.setText(archiveName)
        
        self.cvsTagValidator = QRegExpValidator(QRegExp(r"[a-zA-Z][a-zA-Z0-9_-]*"), self)
        
        self.vcsVendorEdit.setValidator(self.cvsTagValidator)
        self.vcsReleaseEdit.setValidator(self.cvsTagValidator)
        
    def handleDirectory(self):
        """
        Private slot to display a directory selection dialog.
        """
        directory = KQFileDialog.getExistingDirectory(self.vcsDirectoryEdit.text(),
            self, None, self.trUtf8("Select Repository-Directory"), 1)
            
        if not directory.isNull():
            self.vcsDirectoryEdit.setText(QDir.convertSeparators(directory))
            
    def getData(self):
        """
        Public slot to retrieve the data entered into the dialog.
        
        @return a dictionary containing the data entered
        """
        vcsdatadict = {
            "repository" : unicode(self.vcsDirectoryEdit.text()),
            "archive" : unicode(self.vcsArchiveEdit.text()),
            "vendor" : unicode(self.vcsVendorEdit.text()),
            "message" : unicode(self.vcsLogEdit.text()),
            "release" : unicode(self.vcsReleaseEdit.text()),
        }
        return vcsdatadict
