/* Ergo, version 3.5, a program for linear scaling electronic structure
 * calculations.
 * Copyright (C) 2016 Elias Rudberg, Emanuel H. Rubensson, Pawel Salek,
 * and Anastasia Kruchinina.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Primary academic reference:
 * Kohn−Sham Density Functional Theory Electronic Structure Calculations 
 * with Linearly Scaling Computational Time and Memory Usage,
 * Elias Rudberg, Emanuel H. Rubensson, and Pawel Salek,
 * J. Chem. Theory Comput. 7, 340 (2011),
 * <http://dx.doi.org/10.1021/ct100611z>
 * 
 * For further information about Ergo, see <http://www.ergoscf.org>.
 */
#include <iostream>
#include <stdio.h>
#include <cstdlib>
#include "files_dense.h"
#include "files_sparse.h"

using namespace std;


int main(int argc, char *argv[])
{
  // test sparse
  int nnz = 4;
  int N = 10; 
  int I[]    = { 0, 4, 2, 8 };
  int J[]    = { 3, 8, 7, 5 };
  real val[] = {1.1, 2.2, 3.2, 4.4};

  vector<int>  Iv (I, I + sizeof(I) / sizeof(int));
  vector<int>  Jv (J, J + sizeof(J) / sizeof(int));
  vector<real> valv (val, val + sizeof(val) / sizeof(real)); 

  if(write_matrix_to_mtx("test_sparse.mtx", Iv, Jv, valv, N, N) == -1)
    {
      printf("Error in write_matrix_to_mtx.\n");
      return -1;
    }

  vector<int> Iv2;
  vector<int> Jv2;
  vector<real> valv2;
  int N2;

  read_matrix_from_mtx("test_sparse.mtx", Iv2, Jv2, valv2, N2, N2);

  assert(N == N2);
  assert((int)Iv2.size() == nnz);

  assert(Iv == Iv2);
  assert(Jv == Jv2);
  assert(valv == valv2);

  cout << "All tests finished OK!" << endl;

  return 1;
}
