# -*- coding: utf-8 -*-
#
# Unofficial Epiphany Extension
# Close tabs with middle-click
#
# Copyright (C) 2008 Siegfried Gevatter <rainct@ubuntu.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

import gtk

def attach_window(window):
	notebook = window.get_notebook()
	signal = notebook.connect('button-release-event', _button_release_cb,
		notebook)
	notebook._mcct_extension_signal = signal

def detach_window(window):
	notebook = window.get_notebook()
	notebook.disconnect(notebook._mcct_extension_signal)
	del notebook._mcct_extension_signal

def _button_release_cb(widget, event, notebook):
	# If it isn't the middle mouse button, ignore it.
	if event.button != 2:
		return None
	
	# Let's find which tab was pressed, iterating over all tabs.
	pointer = event.window.get_pointer()
	tab_count = widget.get_n_pages()
	for tab, num in ((widget.get_nth_page(i), i) for i in xrange(0, tab_count)):
		label = notebook.get_tab_label(tab)
		if label.allocation.x < pointer[0] and (label.allocation.x + 
		label.allocation.width) > pointer[0]:
			# Found it, let's remove it.
			tab.get_parent().remove_page(num)
			break
