/*
			       Devices Fetching
 */

#ifndef EDV_DEVICE_GET_H
#define EDV_DEVICE_GET_H

#include <glib.h>
#include "edv_device.h"
#include "edv_context.h"


/*
 *	Returns a list of Devices.
 *
 *	The returned list must not be modified or deleted.
 */
extern edv_device_struct **EDVDevicesList(
	edv_context_struct *ctx, gint *total
);

/*
 *	Matches the object specified by path with a Device who has
 *	the same mount path or device path.
 *
 *	Returns the matched Device or NULL on error, the returned
 *	Device must not be modified or deleted.
 */
extern edv_device_struct *EDVDeviceMatch(
	edv_context_struct *ctx, const gchar *path
);


#endif	/* EDV_DEVICE_GET_H */
