/*
                            Endeavour Status Bar

	Status bar with Endeavour-specific controls, progress bar, and
	status message.
 */

#ifndef EDV_STATUS_BAR_H
#define EDV_STATUS_BAR_H

#include <gtk/gtk.h>
#include "edv_types.h"


typedef struct _edv_status_bar_struct	edv_status_bar_struct;
#define EDV_STATUS_BAR(p)	((edv_status_bar_struct *)(p))


/*
 *	Status Bar:
 */
struct _edv_status_bar_struct {

	GtkWidget	*toplevel;		/* GtkFrame */
	gint		busy_count,
			freeze_count;
	edv_core_struct	*core;

	GtkWidget	*write_protect_enabled_eb,
			*write_protect_disabled_eb,
			*delete_method_recycle_eb,
			*delete_method_purge_eb,
			*progress_bar,	/* GtkProgressBar */
			*label;		/* GtkLabel */

	gfloat		progress_pos_last;
};


extern edv_status_bar_struct *EDVStatusBarNew(
	edv_core_struct *core, GtkWidget *parent
);
extern void EDVStatusBarUpdate(edv_status_bar_struct *sb);
extern void EDVStatusBarSetBusy(
	edv_status_bar_struct *sb, gboolean busy
);
extern void EDVStatusBarMap(edv_status_bar_struct *sb);
extern void EDVStatusBarUnmap(edv_status_bar_struct *sb);
extern void EDVStatusBarDelete(edv_status_bar_struct *sb);

extern void EDVStatusBarMessage(
	edv_status_bar_struct *sb, const gchar *message,
	gboolean allow_gtk_iteration
);
extern void EDVStatusBarProgress(
	edv_status_bar_struct *sb, gfloat percent,
	gboolean allow_gtk_iteration
);


#endif	/* VMAEDV_STATUS_BAR_H */
