/*
                        Endeavour Recycled Object
 */

#ifndef EDV_RECYCLED_OBJ_H
#define EDV_RECYCLED_OBJ_H

#include <glib.h>
#include "edv_types.h"
#include "edv_obj.h"


typedef struct _edv_recycled_object_struct	edv_recycled_object_struct;
#define EDV_RECYCLED_OBJECT(p)	((edv_recycled_object_struct *)(p))


/*
 *	Recycled Object:
 */
struct _edv_recycled_object_struct {

	/* Original name of object */
	gchar		*name;

	/* Full path to original location, without the object's name */
	gchar		*original_path;

	/* Recycled object index number, this will be formatted into
	 * a string and matches an object of type file in the recycled 
	 * objects directory
	 */
	guint		index;

	/* Time when this object was recycled (in systime seconds) */
	gulong		deleted_time;


	/* Following are original statistics of the object */

	edv_object_type	type;

	gchar		*link_value;	/* Only for EDV_OBJECT_TYPE_LINK */

	edv_permission_flags permissions;	/* Any of EDV_PERMISSION_* */

	gulong		access_time,	/* In systime seconds */
			modify_time,
			change_time;

	gint		owner_id,
			group_id;

	gulong		size;	/* Original size of the object in bytes,
				 * this applies only to objects of type
				 * EDV_OBJECT_TYPE_FILE
				 */

};


/* edv_recycled_obj.c */
extern edv_recycled_object_struct *EDVRecycledObjectNew(void);
extern edv_recycled_object_struct *EDVRecycledObjectCopy(
	const edv_recycled_object_struct *obj
);
extern void EDVRecycledObjectDelete(
	edv_recycled_object_struct *obj
);


#endif	/* EDV_RECYCLED_OBJ_H */
