#include "encompass.h"
#include <gtkhtml/htmlengine.h>
#include <gtkhtml/htmlobject.h>
#include <gtkhtml/htmlimage.h>
#include <gtkhtml/htmllinktext.h>

static GnomeUIInfo popup_menu[] = {
  {
    GNOME_APP_UI_ITEM,
    N_("Back"), N_("Return to the previous page in the history list"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
    GDK_Left, GDK_MOD1_MASK, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Forward"), N_("Go to the next page in the history list"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
    GDK_Right, GDK_MOD1_MASK, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM,
    N_("Open Link"), N_("Open this Link in the Current Window"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Open Link in New Window"), N_("Open this Link in a New Window"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Download Link..."), N_("Download this Link with Elysium Download"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM,
    N_("View Image"), N_("View this Image"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("View Image in New Window"), N_("View this Image in a New Window"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Save Image..."), N_("Save this Image"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM,
    N_("Add Page to Bookmarks..."), N_("Add this Page to Your Bookmarks"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Add Link to Bookmarks..."), N_("Add this Link to Your Bookmarks"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("View Page Source"), N_("View the Current Page's Source"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_SEPARATOR,
  {
    GNOME_APP_UI_ITEM,
    N_("Copy"), N_("Copy the Selected Text to the Clipboard"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Copy Link Location"), N_("Copy Link Location to the Clipboard"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  {
    GNOME_APP_UI_ITEM,
    N_("Copy Image Location"), N_("Copy Image Location to the Clipboard"),
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, 0, NULL
  },
  GNOMEUIINFO_END
};

static void encompass_open_link (GtkWidget * widget, BrowserWindow * window) {
  gchar * url;

  url = encompass_parse_url ((gchar *)html_object_get_url (window->object),
			     window->base);
  encompass_goto_url (window, url, 0);
  g_free (url);
}

static void encompass_open_image (GtkWidget * widget, BrowserWindow * window) {
  gchar * url;

  url = encompass_parse_url (HTML_IMAGE (window->object)->image_ptr->url,
			     window->base);
  encompass_goto_url (window, url, 0);
  g_free (url);
}

static void encompass_open_link_new (GtkWidget * widget,
				     BrowserWindow * window) {
  gchar * url;

  url = encompass_parse_url ((gchar *)html_object_get_url (window->object),
			       window->base);
  encompass_create_window (widget, url);
  g_free (url);
}

static void encompass_open_image_new (GtkWidget * widget,
				     BrowserWindow * window) {
  gchar * url;

  url = encompass_parse_url (HTML_IMAGE (window->object)->image_ptr->url,
			     window->base);
  encompass_create_window (widget, url);
  g_free (url);
}

static void encompass_copy_link_location (GtkWidget * widget,
					  BrowserWindow * window) {
  const HTMLLinkText * master = HTML_LINK_TEXT (window->object);
  static gchar * url = NULL;

  url = encompass_parse_url (master->url, window->base);
  gtk_object_set_data (GTK_OBJECT (window->window), "selection", url);
  gtk_selection_owner_set (window->window, GDK_SELECTION_PRIMARY,
			   GDK_CURRENT_TIME);
  g_free (url);
}

static void encompass_copy_image_location (GtkWidget * widget,
					   BrowserWindow * window) {
  gchar * url;

  url = encompass_parse_url (HTML_IMAGE (window->object)->image_ptr->url,
			     window->base);
  gtk_object_set_data (GTK_OBJECT (window->window), "selection", url);
  gtk_selection_owner_set (window->window, GDK_SELECTION_PRIMARY,
			   GDK_CURRENT_TIME);
  g_free (url);
}

static void encompass_download_object (GtkWidget * widget,
				       BrowserWindow * window) {
  CORBA_Environment ev;
  GNOME_Elysium_Download_Shell corba_shell = NULL;
  gchar * url;

  if (HTML_IS_IMAGE (window->object)) {
    gchar * imgsrc = g_strdup (HTML_IMAGE (window->object)->image_ptr->url);

    url = encompass_parse_url (imgsrc, window->base);
    g_free (imgsrc);
  } else {
    url = encompass_parse_url ((gchar *)html_object_get_url (window->object),
			       window->base);
  }
  CORBA_exception_init (&ev);
  corba_shell =
    bonobo_activation_activate_from_id ("OAFIID:GNOME_Elysium_Download_Shell",
					0, NULL, &ev);
  if (ev._major != CORBA_NO_EXCEPTION || corba_shell == CORBA_OBJECT_NIL) {
  } else {
    GNOME_Elysium_Download_Shell_handleURI (corba_shell, url, &ev);
  }
  CORBA_exception_free (&ev);  
  g_free (url);
}

static void encompass_save_object_as (GtkWidget * widget,
				      BrowserWindow * window) {
  CORBA_Environment ev;
  GNOME_Elysium_Download_Shell corba_shell;
  gchar * url;

  if (HTML_IS_IMAGE (window->object)) {
    gchar * imgsrc = g_strdup (HTML_IMAGE (window->object)->image_ptr->url);

    url = encompass_parse_url (imgsrc, window->base);
    g_free (imgsrc);
  } else {
    url = encompass_parse_url ((gchar *)html_object_get_url (window->object),
			       window->base);
  }
  CORBA_exception_init (&ev);
  corba_shell =
    bonobo_activation_activate_from_id ("OAFIID:GNOME_Elysium_Download_Shell",
					0, NULL, &ev);
  if (ev._major != CORBA_NO_EXCEPTION || corba_shell == CORBA_OBJECT_NIL) {
  } else {
    GNOME_Elysium_Download_Shell_save_uri_as (corba_shell, url, &ev);
  }
  CORBA_exception_free (&ev);  
  g_free (url);
}

void encompass_menu_popup (GdkEventButton * event, BrowserWindow * window) {
  guint offset;
  GtkHTML * htmlitem = GTK_HTML (window->html);

  if (window->object) {
    window->object = NULL;
  }
  window->object =
    html_engine_get_object_at (htmlitem->engine,
			       event->x + htmlitem->engine->x_offset,
			       event->y + htmlitem->engine->y_offset,
			       &offset, FALSE);

  if (html_engine_is_selection_active (htmlitem->engine)) {
    gtk_widget_set_sensitive (popup_menu[15].widget, TRUE);
  } else {
    gtk_widget_set_sensitive (popup_menu[15].widget, FALSE);
  }
  if (window->object != NULL && html_object_get_url (window->object)) {    gtk_widget_show (popup_menu[2].widget);
    gtk_widget_show (popup_menu[3].widget);
    gtk_widget_show (popup_menu[4].widget);
    gtk_widget_show (popup_menu[5].widget);
    gtk_widget_show (popup_menu[12].widget);
    gtk_widget_show (popup_menu[16].widget);
    if (gnome_is_program_in_path ("elysium-download")) {
      gtk_widget_set_sensitive (popup_menu[5].widget, TRUE);
    } else {
      gtk_widget_set_sensitive (popup_menu[5].widget, FALSE);
    }
  } else {
    gtk_widget_hide (popup_menu[2].widget);
    gtk_widget_hide (popup_menu[3].widget);
    gtk_widget_hide (popup_menu[4].widget);
    gtk_widget_hide (popup_menu[5].widget);
    gtk_widget_hide (popup_menu[12].widget);
    gtk_widget_hide (popup_menu[16].widget);
  }
  if (window->object != NULL && HTML_IS_IMAGE (window->object)) {
    gtk_widget_show (popup_menu[6].widget);
    gtk_widget_show (popup_menu[7].widget);
    gtk_widget_show (popup_menu[8].widget);
    gtk_widget_show (popup_menu[9].widget);
    gtk_widget_show (popup_menu[17].widget);
    if (!strcmp (HTML_IMAGE (window->object)->image_ptr->url,
		 gtk_entry_get_text (GTK_ENTRY (window->entry)))) {
      gtk_widget_set_sensitive (popup_menu[7].widget, FALSE);
    } else {
      gtk_widget_set_sensitive (popup_menu[7].widget, TRUE);
    }
    if (gnome_is_program_in_path ("elysium-download")) {
      gtk_widget_set_sensitive (popup_menu[9].widget, TRUE);
    } else {
      gtk_widget_set_sensitive (popup_menu[9].widget, FALSE);
    }
  } else {
    gtk_widget_hide (popup_menu[6].widget);
    gtk_widget_hide (popup_menu[7].widget);
    gtk_widget_hide (popup_menu[8].widget);
    gtk_widget_hide (popup_menu[9].widget);
    gtk_widget_hide (popup_menu[17].widget);
  }
  gtk_widget_set_sensitive (popup_menu[11].widget, FALSE);
  gtk_widget_set_sensitive (popup_menu[12].widget, FALSE);
  gtk_widget_set_sensitive (popup_menu[13].widget, FALSE);
  gtk_widget_set_sensitive (popup_menu[15].widget, FALSE);

  gtk_menu_popup (GTK_MENU (window->popup_item), NULL, NULL, NULL, NULL,
		  event->button, event->time);
}

void encompass_context_menu_init (BrowserWindow * window) {
  window->popup_item = gnome_popup_menu_new (popup_menu);

  window->back_pop_item = popup_menu[0].widget;
  window->fore_pop_item = popup_menu[1].widget;
  gtk_widget_set_sensitive (window->back_pop_item, FALSE);
  gtk_widget_set_sensitive (window->fore_pop_item, FALSE);

  gtk_signal_connect (GTK_OBJECT (popup_menu[0].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_history_go_back), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[1].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_history_go_forward), window);

  gtk_signal_connect (GTK_OBJECT (popup_menu[3].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_open_link), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[4].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_open_link_new), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[5].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_download_object), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[16].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_copy_link_location), window);

  gtk_signal_connect (GTK_OBJECT (popup_menu[7].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_open_image), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[8].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_open_image_new), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[9].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_save_object_as), window);
  gtk_signal_connect (GTK_OBJECT (popup_menu[17].widget), "activate",
		      GTK_SIGNAL_FUNC (encompass_copy_image_location), window);
}
