#ifndef PBX_ROUTINES_H
#define PBX_ROUTINES_H


#ifdef linux
# if !defined __off64_t_defined
typedef __off64_t off64_t;
#define __off64_t_defined
#endif
#define __USE_LARGEFILE64
#define _LARGEFILE64_SOURCE
#endif

#include <stdio.h>
#include <sys/types.h>

#include "hash.h"

#ifdef FOPEN64
#define OFF_T off64_t
extern OFF_T ftello64(FILE *);
#else
#define OFF_T off_t
#endif

#define _fcd char *
#define fortint int
/*#define integer int*/
#define integer OFF_T
#define bool int

#define MAX_NUMBER_OF_GRIBS 100

typedef struct hit {
  integer index;
  integer length;
  unsigned char* bytes;
} hit;

typedef struct hashValue {
  integer value;
  integer numberOfHits;
  integer maximumNumberOfHits;
  hit** hitList;
} hashValue;

typedef struct hashTable {
  integer numberOfEntries;
  integer maximumNumberOfEntries;
  hashValue** entries;
} hashTable;

typedef struct gribfile {
  FILE *  fp;
  _fcd    fname;
  char readwriteflag;
  integer max;
  integer count;
  OFF_T * offset;
  OFF_T * length;
  hashTable* fileHashTable;
  struct gribfile *next;
}gribfile;

typedef struct collection {
  integer (* exists)(_fcd , fortint);
  integer (* addRead)(_fcd , fortint);
  integer (* addWrite)(_fcd , fortint);
  void (* removeFile)(_fcd , fortint);
  integer count;
  integer max;
  struct gribfile * files;
}collection;


/*
// Prototypes
*/

#ifdef __cplusplus
extern "C" {
#endif

fortint pbxtotl(_fcd filename, fortint filename_len);
fortint pbxtotl_(_fcd filename, fortint filename_len);
fortint pbxxfind_(fortint * grib1, _fcd filename, fortint filename_len);
fortint pbxxfind(fortint * grib1, _fcd filename, fortint filename_len);

fortint pbxget(_fcd filename, fortint * buffer, fortint * bufflen,
               fortint * n, fortint filename_len);
fortint pbxget_(_fcd filename, fortint * buffer, fortint * bufflen,
               fortint * n, fortint filename_len);
void pbxclos(_fcd filename, fortint filename_len);
void pbxclos_(_fcd filename, fortint filename_len);

#ifdef __cplusplus
}
#endif

#endif /* end of  PBX_ROUTINES_H */
