#!/bin/sh

. ./include.sh

#export JDCNDBG=1
#export INTF2_DEBUG=1

EMOSLIB_FILES=${src_dir}/tables/interpol
export EMOSLIB_FILES

compare="$grib_compare -P -T 2 -f"

tool=./interpolation
data=${src_dir}/tests/data_in
out=./data_out
ref=${src_dir}/tests/data_ref

mkdir -p $out

option=ll
x=spectral-ll.grib
file=spectral.grib

echo "******************************"
echo "     SH to LL             ****"
echo "******************************"
$tool $option $data/$file $out/$x
$compare ${ref}/$x $out/$x

option=qr
x=spectral-rg.grib

echo "******************************"
echo "     SH to RG             ****"
echo "******************************"
$tool $option $data/$file $out/$x
$compare ${ref}/$x $out/$x

