      PROGRAM INTERPOLATION
C
      IMPLICIT NONE
      INTEGER IPROD
      INTEGER INTV
      REAL REALV
      CHARACTER*20 CHARV
      DIMENSION INTV(4), REALV(4), CHARV(4)
C
      INTEGER JPGRIB, JPEXPAND, JPLONG, JPLAT, JPBYTES
C
C     This should allow an 0.5 degree global grid as input(if required)
C
      PARAMETER(JPGRIB = 2000000)
C
      PARAMETER(JPBYTES = 4)
      PARAMETER(JPLONG = 361)
      PARAMETER(JPLAT  = 720)
      PARAMETER(JPEXPAND = JPLONG * JPLAT)
C
      INTEGER IOGRIB(JPGRIB), INGRIB(JPGRIB)
C
      REAL ZNFELDI(JPEXPAND), ZNFELDO(JPEXPAND)
C
      INTEGER IUNIT1, IUNIT2, IREC, INLENG, IERR, IRET
C
C     Externals
C
      INTEGER INTOUT, INTF2, IARGC
C
      CHARACTER*2 OPTION
      CHARACTER*128 INFILE, OUTFILE
      INTEGER IJDC
      EXTERNAL GETENV
C
      IJDC = IARGC()
      IF( IJDC.LT.3 ) THEN
       print*,'Usage: ./interpolation option inputfile outputfile'
       print*,'Possible options:'
       print*,'ll-spectral to lat-long or any grid to lat long'
       print*,'gg-spectral to regular gaussian or any grid to gaussian'
       print*,'qr-spectral to red gaussian or red gaussian red gaussian'
       STOP
      ENDIF

      CALL GETARG(1,OPTION)
      CALL GETARG(2,INFILE)
      CALL GETARG(3,OUTFILE)
C
      IRET = 0
C
C     Turn on autoresol
C
      INTV(1) = 1
      IRET = INTOUT('autoresol', INTV, REALV, CHARV)
      IF( IRET.NE.0 ) STOP 'autoresol INTOUT failed.'
C
C     Define area to be used for interpolating the new field(s).
C
      REALV(1) = 0.0
      REALV(2) = 0.0
      REALV(3) = 0.0
      REALV(4) = 0.0

      IRET = INTOUT('area', INTV, REALV, CHARV)
      IF( IRET.NE.0 ) STOP 'area INTOUT failed.'
C
C     Define grid to be used for interpolating the new field(s).
C
      IF( OPTION.EQ.'ll' ) THEN
        REALV(1) = 0.5
        REALV(2) = 0.5
        IRET = INTOUT('grid', INTV, REALV, CHARV)
        IF( IRET.NE.0 ) STOP 'grid INTOUT failed.'
      ENDIF
C
      IF( OPTION.EQ.'gg' ) THEN
        INTV(1) = 80
        IRET = INTOUT('regular', INTV, REALV, CHARV)
        IF( IRET.NE.0 ) STOP 'regular INTOUT failed.'
      ENDIF
C
C
      IF( OPTION.EQ.'qr' ) THEN
        INTV(1) = 80
        IRET = INTOUT('reduced', INTV, REALV, CHARV)
        IF( IRET.NE.0 ) STOP 'reduced INTOUT failed.'
      ENDIF
C
C     Open input and output files.
C
      CALL PBOPEN(IUNIT1, infile, 'r', IERR)
      IF( IERR.NE.0 ) STOP 'PBOPEN failed'
      CALL PBOPEN(IUNIT2, outfile, 'w', IERR)
      IF( IERR.NE.0 ) STOP 'PBOPEN failed'
      IPROD = 0
C
C     Start of loop through input GRIB-coded fields
C
 200  CONTINUE
C
        IPROD = IPROD + 1
C
C       READ next product
C
        CALL PBGRIB(IUNIT1, IOGRIB, JPGRIB * JPBYTES, IREC, IERR)
        IF( IERR .EQ. -1 ) GOTO 900
        IF( IERR .NE. 0 ) STOP 'PBGRIB failed'
C
C       Interpolate
C
        WRITE(*,*) ' Interpolate product number ', IPROD
        INLENG = JPGRIB
        IRET = INTF2(IOGRIB,IREC,INGRIB,INLENG)
        IF( IRET.NE.0 ) STOP 'INTF failed.'
C
C       Write the new product to file
C
        IF( INLENG.GT.0 ) THEN
          CALL PBWRITE( IUNIT2, INGRIB, INLENG*JPBYTES, IERR)
        ELSE
          WRITE(*,*) 'Output same as input'
          CALL PBWRITE( IUNIT2, IOGRIB, IREC, IERR)
        ENDIF
        IF( IERR.LT.0 ) STOP 'PBWRITE failed'
C
C       Loop back for next product
C
      GOTO 200
C
C     Closedown
C
 900  CONTINUE
C
      IPROD = IPROD - 1
      WRITE(*,*) ' All done after ', IPROD, ' products.'
C
C     Close input and output files.
C
      CALL PBCLOSE(IUNIT1, IERR)
      CALL PBCLOSE(IUNIT2, IERR)
C
      STOP
      END
