/**
* Copyright 1981-2012 ECMWF.
*
* This software is licensed under the terms of the Apache Licence 
* Version 2.0 which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
*
* In applying this licence, ECMWF does not waive the privileges and immunities 
* granted to it by virtue of its status as an intergovernmental organisation 
* nor does it submit to any jurisdiction.
*/

#include <stdio.h>

#include "bitmap.h"

void SHOWMAP(
  char ** mybuffer,
  int * rowCount,
  int * columnCount) {
/*
// Displays the bits in a bitmap.
//
// Called from FORTRAN:
//
// CALL SHOWMAP(BITMAP,ROWCNT,COLCNT)
//
// where:
//
// BITMAP is an array containing the bitmap.
// ROWCNT is the number of rows
// COLCNT is the number of columns
//
*/
int value, i, j, bitNumber, byte, bit;
int rowTotal = *rowCount;
int columnTotal = *columnCount;
char * buffer;

  buffer = *mybuffer;

  for( i = 0; i < rowTotal; i++ ) {
    printf("\n");
    for( j = 0; j < columnTotal; j++ ) {
      bitNumber = i*columnTotal + j;
      byte = bitNumber / 8;
      bit  = bitNumber % 8;
      value = (buffer[byte] >> (7-bit)) & 0x01;
      printf("%d ", value);
    }
  }
  printf("\n");

}
