/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "fortint.h"

#ifdef FORTRAN_NO_UNDERSCORE
#define JINDEX jindex
#else
#define JINDEX jindex_
#endif

fortint JINDEX(char * name, long len) {
/*
// Called from Fortran:
//
//   LEN = JINDEX(NAME)
//
//   Returns the length of the character string (including embedded
//   blanks).
*/
fortint offset = len;
char next;

  do {
    offset--;
    next = *(name+offset);
    if( next != ' ' ) {
      return (offset+1);
    }
  } while( offset >= 0 );

  return len;

}
