/* $Id: e2_plugins.h 514 2007-07-15 02:46:39Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef _E2_PLUGINS_H
#define _E2_PLUGINS_H

#include "emelfm2.h"

/*values for lookup table of 'main program' functions, usable by plugins
NOTE: not all actually-used main-program functions are accessible via this
API, so that plugins need to be compiled with the main program, ans
this interface is fairly nominal, more for example than core use !
*/
/*enum { E2API_ACTION_REGISTER = 0,
			E2API_ACTION_UNREGISTER,
			E2API_ACTION_GET,
			E2API_OPTION_GET,
			E2API_OPTION_REGISTER,
			E2API_REFRESH_DISABLE,
			E2API_REFRESH_ENABLE,
			E2API_POINTER_COUNT		//the last value, used for size checks
			};
*/

/* To provide for multiple-actions in any plugin, this runtime data struct is used
 in 2 ways. When there is more than one action, a "parent" Plugin struct contains
 a list of "child" Plugin structs, one for each action.
 All Plugins, parents and children, are added to app.plugins as a flat list */
typedef struct _E2_Plugin
{
//	gchar *name;  //action name FOR debugging only
	const gchar *signature;	//ID string, never alters after it's set
	//this group of members will be NULL in any Plugin listed in action_list
	GModule *module;
	gboolean (*plugin_init)();  //fn called by main program, to let the plugin initialize itself

	GList *child_list;	//list of Plugins, each with action-specific data,
						//or NULL if only 1 action, and then the following will be used ...
	const gchar *icon;  //user-editable context-menu icon file path (or "gtk-<...>")
	const gchar *menu_name;  //user-editable name that appears in the plugins menu
	const gchar *description;  //user-editable context-menu tooltip (useless for a sub-menu item)
	gboolean show_in_menu;  //TRUE if the plugin is to appear in the file-pane context menu
	E2_Action *action;	//what to run
} Plugin;

typedef struct _E2P_DirEnt
{
	gchar *path;
	mode_t mode;
} E2P_DirEnt;

// Plugins
//void *e2_plugins_api_lookup (gint type);
Plugin *e2_plugins_open1 (gchar *filepath);
gboolean e2_plugins_unload1 (Plugin *p, gboolean force);
void e2_plugins_load_all (void);
void e2_plugins_unload_all (void);
void e2_plugins_store_child_data (GtkTreeModel *model, GtkTreeIter *iter, Plugin *p);
void e2_plugins_update (void);
gboolean e2_plugins_configure (gpointer from, E2_ActionRuntime *art);
E2_Action *e2_plugins_action_register (gchar *name, E2_ACTION_TYPE type,
	void *func, gpointer data, gboolean has_arg, E2_ACTION_EXCLUDE exclude,
	gpointer data2);
gboolean e2_plugins_action_unregister (gchar *name);
void e2_plugins_do_action (GtkWidget *widget, E2_Action *action);
//Plugin *get_plugin_by_name (gchar *name);
Plugin *e2_plugins_check_installed (const gchar *signature);
gboolean e2_plugins_find_function (const gchar *signature, const gchar *func_name,
	gpointer *address);
Plugin *e2_plugins_create_child (Plugin *parent);
GList *e2_plugins_get_list (void);
E2_OptionSet *e2_plugins_option_register (E2_OptionType type, gchar *name,
	gchar *group, gchar *desc, gchar *tip, gchar *depends, E2_OptionFlags flags);
gboolean e2_plugins_option_unregister (gchar *name);
void e2_plugins_options_register (void);

#endif //ndef _E2_PLUGINS_H
