/* $Id: e2_command.h 555 2007-07-23 09:39:52Z tpgww $

Copyright (C) 2004-2007 tooar <tooar@gmx.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#ifndef E2_COMMAND_H
#define E2_COMMAND_H

#include "emelfm2.h"
#include "e2_output.h"

//enable queueing of entered commands
//#define E2_COMMANDQ

//flags governing the way a command is interpreted and run
typedef enum
{
	E2_COMMAND_RANGE_DEFAULT = 1,
	E2_COMMAND_RANGE_FILE_ACTION = 1 << 1,
	E2_COMMAND_RANGE_FILE_OPERATION = 1 << 2,	//add names of selected items
	E2_COMMAND_RANGE_SUBSHELL = 1 << 3,
	E2_COMMAND_RANGE_TOCHILD = 1 << 4,	//send string to last-started child
	E2_COMMAND_RANGE_CUSTOM = 1 << 5
} E2_CommandRange;

typedef struct _E2_CommandTaskData
{
	gchar *command;	//command string
	gchar *currdir;	//the CWD when command is initiated (utf-8)
#ifdef E2_COMMANDQ
	//data to allow later interpretation (for %D, %f, %F etc) and exection
	gchar *othrdir;	//the inactive pane dir when command is initiated (utf-8)
	GPtrArray *names;	//selected items array
	GPtrArray *othernames;	//selected items array
	E2_CommandRange range;
# ifdef E2_VFSTMP
	//FIXME need "fstab" data for 2 panes if command is queued and needs CWD or has %fFdDpP
# endif
#endif
#ifdef E2_NEW_COMMAND
	gint child_stdin_fd;	//pipe file descriptors, parent-side
	gint child_stdout_fd;
	gint child_stderr_fd;
	gboolean sync;	//TRUE for synchronously-run command
#else
	GIOChannel *to_child;	//channel used for messages to an async child (= child's stdin)
#endif
	gboolean extshell;	//TRUE for command run in external shell
	gboolean show;	//TRUE to display start and end messages for the command
	gint exit;	//command exit code, 0 = success
} E2_CommandTaskData;

gboolean e2_command_clear_pending (gpointer from, E2_ActionRuntime *art);
gboolean e2_command_find_process (guint pid);
gint e2_command_run_at (gchar *command, gchar *workdir, E2_CommandRange range);
gint e2_command_run (gchar *command, E2_CommandRange range);
guint e2_command_count_running_tasks (gboolean countcmds, gboolean countpaused);
void e2_command_retab_children (E2_OutputTabRuntime *currenttab,
	E2_OutputTabRuntime *replacetab);
void e2_command_retab2_children (E2_OutputTabRuntime *currenttab,
	E2_OutputTabRuntime *replacetab);
gboolean e2_command_kill_child (guint pid);
const gchar *e2_command_get_variable_value (gchar *var_name);
void e2_command_output_help (void);
void e2_command_actions_register (void);
void e2_command_options_register (void);

#endif //ndef E2_COMMAND_H
