#!/bin/sh

#  Copyright (C) 2008  Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

SELECTIONS=$1

if [ -z "$SELECTIONS" ]; then
	echo "Please specify the file containing the output of dpkg --get-selections"
	exit 1
fi

if [ ! -f $SELECTIONS ]; then
	echo "Cannot find '$SELECTIONS' containing the output of dpkg --get-selections"
	exit 2
fi
MISSING=`mktemp -t -d gripliststd.XXXXXX`
grep install $SELECTIONS | cut -d' ' -f1 | sort -u > $MISSING/installed
cd $MISSING
echo "Updating package list"
wget http://buildd.emdebian.org/grip/pkglist
cat pkglist | sed -e 's/\t/ /' |  grep install | cut -d' ' -f1 | sort -u > packages
diff -u installed packages|grep "^\-" |grep -v installed| sed -e 's/^-//' > list
rm packages installed
echo "Missing 'Priority: standard' packages:"
echo "Known empty packages: debian-faq doc-debian doc-linux-text"
echo "Standard packages not working with Emdebian: reportbug"

for PKG in `cat list`; do 
	if [ "$PKG" = "grip-config" ]; then
		continue
	fi
	STD=`apt-cache showsrc $PKG | grep Priority | grep standard`
	SRC=`apt-cache showsrc $PKG | grep Package | cut -d':' -f2 | sed -e 's/ //g'`
	if [ -n "$STD" ]; then
		echo "  $PKG ($SRC)"
		continue
	fi
	OPT="$OPT $PKG"
done
echo "Others: $OPT" | fold -s
rm list
cd
rm -rf $MISSING
