#!/bin/sh

set -e

# cron support - runs silently using a log file

#  Copyright (C) 2008, 2009  Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

while [ -n "$1" ]; do
case "$1" in
	-b|--base-path)
		shift
		BASE=$1
		shift
	;;
	*)
		echo "Unrecognised option: $1" 1>&2
		echo 1>&2
		exit 3
	;;
esac
done

if [ -z "$BASE" ]; then
	echo "No base path specified, ensure you use '-b'" 1>&2
	exit 5
fi

if [ ! -d "$BASE" ]; then
	echo "Unable to find base directory: $BASE" 1>&2
	exit 4
fi

# some udebs simply don't exist even though a binary udeb
# depends on them.
add_equivs()
{
	TMPFILE=$1
	echo >> $TMPFILE
	echo "Package: mouse-modules" >> $TMPFILE
	echo "Version: 0.0.1" >> $TMPFILE
	echo >> $TMPFILE
	echo "Package: ppp-modules" >> $TMPFILE
	echo "Version: 0.0.1" >> $TMPFILE
	echo >> $TMPFILE
	echo "Package: jfs-modules" >> $TMPFILE
	echo "Version: 0.0.1" >> $TMPFILE
	echo >> $TMPFILE
	echo "Package: xfs-modules" >> $TMPFILE
	echo "Version: 0.0.1" >> $TMPFILE
	echo >> $TMPFILE
}

STAMP=`date +%s | tr -d '\n'`
LOGFILE="$BASE/grip/logs/$STAMP.log"
if [ ! -d $BASE/grip/logs/ ]; then
	mkdir -p $BASE/grip/logs/
fi
cd $BASE
nice -n 7 em_autogrip -b $BASE >$LOGFILE 2>&1
echo >> $LOGFILE
echo "Updating the udeb packages in grip:" >> $LOGFILE
echo >> $LOGFILE
echo "Looking for missing dependencies in grip:" >> $LOGFILE
nice -n 7 em_autogrip -b $BASE --edos 2>/dev/null >>$LOGFILE
echo "Adding any identified dependencies:" >> $LOGFILE
nice -n 7 em_autogrip -b $BASE 2>/dev/null >>$LOGFILE
# pull the udeb updates into grip directly but ignore STDERR
nice -n 7 reprepro -v -b $BASE/grip update 2>/dev/null >> $LOGFILE
/usr/share/emdebian-tools/grip-overridearch.pl -b $BASE -s unstable 2>/dev/null >> $LOGFILE
# get the archlist from the perl module.
ARCHLIST=`BASE=$BASE perl -MDebian::Packages::Compare -e 'set_base("$ENV{BASE}"); $a=&get_archlist("unstable", "grip"); $s=join (" ", @$a); $s=~s/source//; chomp($s); print "$s\n";'`
if [ -z "$ARCHLIST" ]; then
	ARCHLIST="i386 amd64 arm armel powerpc mips mipsel"
fi
echo "Beginning dependency checks." >> $LOGFILE
for ARCH in $ARCHLIST; do
	echo >> $LOGFILE
	echo "Checking $ARCH" >> $LOGFILE
	echo >> $LOGFILE
	# collate Packages files into a temp file
	TMPFILE=`mktemp /tmp/grip-cron-XXXXXX`
	cat grip/dists/unstable/main/binary-$ARCH/Packages > $TMPFILE
	echo >> $TMPFILE
	cat grip/dists/unstable/main/debian-installer/binary-$ARCH/Packages >> $TMPFILE
	echo >> $TMPFILE
	if [ -f "grip/dists/unstable/dev/binary-$ARCH/Packages" ]; then
		cat grip/dists/unstable/dev/binary-$ARCH/Packages >> $TMPFILE
		echo >> $TMPFILE
	fi
	if [ -f "grip/dists/unstable/doc/binary-$ARCH/Packages" ]; then
		cat grip/dists/unstable/doc/binary-$ARCH/Packages >> $TMPFILE
		echo >> $TMPFILE
	fi
	if [ $ARCH = "mipsel" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "mips" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "arm" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "armel" ]; then
		add_equivs $TMPFILE
	fi
	nice -n 7 edos-debcheck -explain -failures < $TMPFILE 2>/dev/null >> $LOGFILE
	rm $TMPFILE
done

echo >> $LOGFILE
echo "Starting testing update:" >> $LOGFILE
echo >> $LOGFILE
nice -n 7 em_autogrip -b $BASE -t --add-new 2>/dev/null >>$LOGFILE || true
nice -n 7 em_autogrip -b $BASE -t 2>/dev/null >>$LOGFILE || true
/usr/share/emdebian-tools/grip-overridearch.pl -b $BASE -s testing 2>/dev/null >> $LOGFILE
for ARCH in $ARCHLIST; do
	TMPFILE=`mktemp /tmp/grip-cron-XXXXXX`
	echo >> $LOGFILE
	echo "Checking $ARCH" >> $LOGFILE
	echo >> $LOGFILE
	cat grip/dists/testing/main/binary-$ARCH/Packages > $TMPFILE
	cat grip/dists/testing/main/debian-installer/binary-$ARCH/Packages >> $TMPFILE
	if [ -f "grip/dists/testing/dev/binary-$ARCH/Packages" ]; then
		cat grip/dists/testing/dev/binary-$ARCH/Packages >> $TMPFILE
		echo >> $TMPFILE
	fi
	if [ -f "grip/dists/testing/doc/binary-$ARCH/Packages" ]; then
		cat grip/dists/testing/doc/binary-$ARCH/Packages >> $TMPFILE
		echo >> $TMPFILE
	fi
	if [ $ARCH = "mipsel" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "mips" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "arm" ]; then
		add_equivs $TMPFILE
	elif [ $ARCH = "armel" ]; then
		add_equivs $TMPFILE
	fi
	nice -n 7 edos-debcheck -explain -failures < $TMPFILE 2>/dev/null >> $LOGFILE
	rm $TMPFILE
done
nice -n 7 em_autogrip -b $BASE --britney 2>/dev/null >> $LOGFILE
