/* Test Emcast - Test/Example Emcast Interface
 * Copyright (c) 2001, The Regents of the University of Michigan
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 *   Redistributions of source code must retain the above 
 *   copyright notice, this list of conditions and the following
 *   disclaimer.
 * 
 *   Redistributions in binary form must reproduce the above 
 *   copyright notice, this list of conditions and the following
 *   disclaimer in the documentation and/or other materials 
 *   provided with the distribution.
 *
 *   Neither the name of the <ORGANIZATION> nor the names of
 *   its contributors may be used to endorse or promote products
 *   derived from this software without specific prior written
 *   permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.  
 */


#include <emcast-protocol.h>

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <netinet/in.h>

static int eminit (unsigned short version, unsigned short* our_version);
static int emjoin (char* url);
static int emleave (void);
static int emsend (char* buf, unsigned short len);
static int emgetopt (char* optname, void* optval, unsigned short* optlen);
static int emsetopt (char* optname, void* optval, unsigned short optlen);

Emfuncs emfuncs = { eminit,
		    emjoin, 
		    emleave,
		    emsend,
		    emgetopt,
		    emsetopt, 0, 0};


static int loopback = 0;
static int fd_fifo;



int
main (int argc, char* argv[])
{
  fprintf (stderr, "echo-emcast start\n");

  emcast_loop (&emfuncs, STDIN_FILENO, STDOUT_FILENO, &fd_fifo);
  exit (EXIT_SUCCESS);
  return 0;
}


/* **************************************** */

static int
eminit (unsigned short version, unsigned short* our_version)
{
  fprintf (stderr, "INIT %d\n", version);
  *our_version = 1;
  return 0;
}

static int
emjoin (char* url)
{
  fprintf (stderr, "JOIN %s\n", url);
  return 0;
}


static int
emleave (void)
{
  fprintf (stderr, "LEAVE\n");
  return 0;
}


static int
emsend (char* buf, unsigned short len)
{
  fprintf (stderr, "SEND %hd ", len);
  write (STDERR_FILENO, buf, len);
  fprintf (stderr, "\n");
  
  return 0;
}


static int
emgetopt (char* optname, void* optval, unsigned short* optlen)
{
  fprintf (stderr, "GETOPT %s\n", optname);

  if (!strcmp(optname, "loopback"))
    {
      (*(int*) optval) = htonl(loopback);
      *optlen = sizeof(int);
    }
  else
    {
      *optlen = 0;
    }

  return 0;
}


static int 
emsetopt (char* optname, void* optval, unsigned short optlen)
{
  fprintf (stderr, "SETOPT %s %hd\n", optname, optlen);

  if (!strcmp(optname, "loopback") && optlen >= sizeof(int))
    {
      if (*(int*)optval)
	loopback = 1;
      else
	loopback = 0;
    }

  return 0;
}
