/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.programs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class RunEmbossApplication {
    private Process p;
    private String stdout;
    private File project;
    private String status;

    public RunEmbossApplication(String embossCommand, String[] envp, File project) {
        this.project = project;
        this.status = "0";
        Runtime embossRun = Runtime.getRuntime();
        try {
            this.p = embossRun.exec(embossCommand, envp, project);
        }
        catch (IOException ioe) {
            System.out.println("RunEmbossApplication Error executing: " + embossCommand);
            this.status = "1";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProcessStdout() {
        block27: {
            this.stdout = "";
            BufferedInputStream stdoutStream = null;
            BufferedReader stdoutRead = null;
            try {
                stdoutStream = new BufferedInputStream(this.p.getInputStream());
                stdoutRead = new BufferedReader(new InputStreamReader(stdoutStream));
                String line = stdoutRead.readLine();
                if (line == null) break block27;
                this.stdout = this.stdout.concat(line + "\n");
                while ((line = stdoutRead.readLine()) != null) {
                    this.stdout = this.stdout.concat(line + "\n");
                }
                if (this.project == null) break block27;
                PrintWriter out = null;
                try {
                    File so = new File(this.project.getCanonicalPath() + "/stdout");
                    so.createNewFile();
                    out = new PrintWriter(new FileWriter(so));
                    out.println(this.stdout);
                }
                catch (IOException ioe) {
                    System.err.println("RunEmbossApplication: Error writing" + this.project.getCanonicalPath() + "/stdout");
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            catch (IOException io) {
                System.err.println("RunEmbossApplication: Error in collecting standard out");
            }
            finally {
                try {
                    if (stdoutStream != null) {
                        stdoutStream.close();
                    }
                }
                catch (IOException ioe) {
                    System.err.println("RunEmbossApplication: Error closing stream");
                }
                try {
                    if (stdoutRead != null) {
                        stdoutRead.close();
                    }
                }
                catch (IOException ioe) {
                    System.err.println("RunEmbossApplication: Error closing reader");
                }
            }
        }
        boolean std = false;
        if (!this.stdout.equals("")) {
            std = true;
        }
        return std;
    }

    public String getProcessStdout() {
        return this.stdout;
    }

    public Process getProcess() {
        return this.p;
    }

    public String getStatus() {
        return this.status;
    }
}

