#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 11;
use EmailReminder::EventList;

my $salutation = 'Hi there,

';
my $footer = 'Have a good day!

--
Sent by Email-Reminder '.$EmailReminder::Utils::VERSION.'
http://www.email-reminder.org.nz/
';

my $strs = [
'I just want to remind you of the following event :

5-a-side

',
'I just want to remind you of the following event today:

5-a-side

',
'I just want to remind you of the following event :

2nd Christmas Day

',
'I just want to remind you of the following event :

3rd New Year\'s Day

',
'I just want to remind you that the 9th anniversary (Pottery) of My Sister and Bro in Law is .

You can reach My Sister at sis.bro-in-law@exmaple.org.

',
'I just want to remind you that the 13th anniversary (Lace) of My Brother and Sis in Law is .

You can reach them at bro.sis-in-law@example.com and sis-in-law@example.com respectively.

',
'I just want to remind you of the following event :

PayDay

',
'I just want to remind you of the following event :

Clean the House

',
'I just want to remind you that Sister is turning 29 .

You can reach Sister at sister@example.org.

',
'I just want to remind you that Bro is turning 33 .

You can reach Bro at bro@example.org.

',
'I just want to remind you that Friend is turning 33 .

You can reach Friend at friend@example.com.

',
];

# tests
my $events = EmailReminder::EventList->new('t/data.xml', 1);

# loop through all the events themselves
my $i = 0;
foreach my $event ($events->get_events()) {
    is($event->get_message, $salutation.$strs->[$i].$footer, "event msg ($i)");
    $i++;
}
