# This file is part of Email-Reminder.
#
# Email-Reminder is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 3 of the
# License, or (at your option) any later version.
#
# Email-Reminder is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Email-Reminder; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

package EmailReminder::Utils;

# Utility subroutines for the Email-Reminder program

use strict;
use XML::DOM;

our $VERSION = '0.7.3';
our $USER_CONFIG_FILE = '.email-reminders';
our $SPOOL_DIRECTORY = '/var/spool/email-reminder';

sub get_node_value
{
    my $node = shift;
    my $tag_name = shift;

    $node = $node->getElementsByTagName($tag_name, 0)->item(0);
    return undef unless $node;
    
    $node = $node->getFirstChild;
    return undef unless $node;

    return $node->getNodeValue;
}

sub set_node_value
{
    my ($node, $tag_name, $new_value) = @_;

    my $subnode = $node->getElementsByTagName($tag_name, 0)->item(0);
    if (!defined($subnode))
    {
        $subnode = $node->getOwnerDocument()->createElement($tag_name);
        $node->appendChild($subnode);
        $subnode->addText($new_value);
    }
    else
    {
        my $textnode = $subnode->getFirstChild();
        if (!defined($textnode))
        {
            $subnode->addText($new_value);
        }
        else
        {
            $textnode->setNodeValue($new_value);
        }
    }
    return 1;
}

1;
