Version 0.11 has been released four months after 0.10, bringing many new
features and bugfixes. There is no newsletter accompanying this release
(instead, there is a
[tweet](https://twitter.com/RealElvishShell/status/953781788706557952)).

As usual, prebuilt binaries can be found in [get](../get/).

# Breaking Changes

-   The syntax for importing modules in nested directories with `use` has
    changed.

    Previously, `use` accepts colon-delimited components, and replace the colons
    with slashes to derive the path: for instance, `use a:b:c` imports the
    module `a/b/c.elv` under `~/.elvish/lib`, under the namespace `a:b:c`. Now,
    to import this module, you should use `use a/b/c` instead, and it will
    import the same file under the namespace `c`.

    It is not yet possible to rename the module when importing it; this makes it
    hard to import modules with the same filename living under different
    directories and will be addressed in the next version.

    The current implementation of `use` still supports the use of colons to
    affect the name under which the module is imported: for instance,
    `use a/b:c` imports the file `a/b/c.elv` under the name `b:c`. However, this
    feature should be considered undocumented and will be removed in the next
    version.

-   Module imports are now scoped lexically, akin to how variables are scoped.
    For instance, `use re` in one module does not affect other files; neither
    does `{ use re }` affect the outer scope.

-   The variable a function `func` maps to is now `$func~` instead of `$&func`.
    The ampersand `&` is now no longer allowed in variable names, while the
    tilde `~` is. A [tool](https://github.com/elves/upgrade-scripts-for-0.11)
    has been provided to rewrite old code.

-   Strings are no longer callable
    ([#552](https://github.com/elves/elvish/issues/552)). A new
    [external](../ref/builtin.html#external) has been added to support calling
    external programs dynamically.

-   It is now forbidden to assign non-strings to environment variables. For
    instance, `E:X = []` used to assign the environment variable `X` the string
    value `"[]"`; now it causes an exception.

# Notable Fixes and Enhancements

## Supported Platforms

-   Support for Go 1.7 has been dropped, and support for Go 1.9 has been added.

-   Elvish now has experimental support for Windows 10. Terminal and filesystem
    features may be buggy. [Prebuilt binaries](../get/) for Windows are also
    available.

-   Prebuilt binaries for AMD64 and ARM64 architectures on Linux are provided.

## Language

-   It is now possible to `use` relative paths. For instance, in module
    `a/b/c/foo.elv` (under `~/.elvish/lib`), `use ./bar` is the same as
    `use a/b/c/bar`, and `use ../bar` is the same as `use a/b/bar`. The resolved
    path must not escape the `lib` directory; for instance, `use ../bar` from
    `~/.elvish/lib/foo.elv` will throw cause a compilation error.

-   A new builtin variable,
    [`$value-out-indicator`](../ref/builtin.html#value-out-indicator), can now
    be used to customize the marker for value outputs
    ([#473](https://github.com/elves/elvish/issues/473)).

-   A new builtin command [`to-string`](../ref/builtin.html#to-string) has been
    added.

-   Special forms like `if` now works correctly with redirections and temporary
    assignments ([#486](https://github.com/elves/elvish/issues/486)).

-   A primitive for running functions in parallel,
    [`run-parellel`](../ref/builtin.html#run-parallel), has been added
    ([#485](https://github.com/elves/elvish/issues/485)).

-   The [`splits`](../ref/builtin.html#splits) builtin now supports a `&max`
    option.

-   A new [`src`](../ref/builtin.html#src) builtin can now be used to get
    information about the current source.

-   A new builtin variable [`$args`](../ref/builtin.html#args) can now be used
    to access command-line arguments.

-   The [`del`](../ref/language.html#deleting-variable-or-element-del) special
    command can now delete map elements
    ([#79](https://github.com/elves/elvish/issues/79)).

## Editor

-   A maximum wait time can be specified with
    [\$edit:-prompts-max-wait](../ref/edit.html#edit-prompts-max-wait) to
    prevent slow prompt functions from blocking UI updates
    ([#482](https://github.com/elves/elvish/issues/482)).

-   Execution of hook functions are now correctly isolated
    ([#515](https://github.com/elves/elvish/issues/515)).

-   A new [matcher](../ref/edit.html#matcher) `edit:match-substr` has been
    added.

-   The editor is now able to handle Alt-modified function keys in more
    terminals ([#181](https://github.com/elves/elvish/issues/181)).

-   Location mode now always hides the current directory
    ([#531](https://github.com/elves/elvish/issues/531)).

-   Ctrl-H is now treated the same as Backspace
    ([#539](https://github.com/elves/elvish/issues/539)).

-   It is now possible to scroll file previews with <kbd>Alt-Up</kbd> and
    <kbd>Alt-Down</kbd>.

-   The height the editor can take up can now be restricted with
    [`$edit:max-height`](../ref/edit.html#editmax-height).

## Misc

-   The Elvish command supports a new `-buildinfo` flag, which causes Elvish to
    print out the version and builder of the binary and exit. Another `-json`
    flag has also been introduced; when present, it causes `-buildinfo` to print
    out a JSON object.

-   Elvish now handles SIGHUP by relaying it to the entire process group
    ([#494](https://github.com/elves/elvish/issues/494)).

-   The daemon now detects the path of the Elvish executable more reliabily,
    notably when Elvish is used as login shell
    ([#496](https://github.com/elves/elvish/issues/496)).

-   When an exception is thrown and the traceback contains only one entry, the
    traceback is now shown more compactly.

    Before:

    ```elvish-transcript
    ~> fail x
    Exception: x
    Traceback:
      [interactive], line 1:
        fail x
    ```

    Now:

    ```elvish-transcript
    ~> fail x
    Exception: x
    [tty], line 1: fail x
    ```
