#ifndef __MAILDIR_H__
#define __MAILDIR_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/*****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "mail.h"
#include "mime.h"
#include "memchunk.h"

/*****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void          maildir_free_resources (void);
extern mail_array_t *maildir_read_dir (const char *dir);
extern mail_array_t *maildir_refresh (mail_array_t *marray);
extern void          maildir_apply_flag (mail_t *mail);
extern void          maildir_apply_flags (mail_array_t *marray);

extern int   maildir_mail_header (mail_t *mail, char **place);
extern int   maildir_mail_body (mail_t *mail, char **place, mime_t *mime,
                                const char *fname);
extern int   maildir_deliver_to (const char *file, const char *box);
extern char *maildir_fetch_single (mail_t *mail);
extern char *maildir_fetch_where (const char *dir, int new);
extern char *maildir_valid_file_name (void);
extern void  maildir_move_to_new (char *fname);
extern void  maildir_move_to_cur (mail_t *mail);
extern void  maildir_remove (mail_t *mail);
extern int   maildir_create_dir (const char *name);
extern int   maildir_mail_size (mail_t *mail);
extern int   maildir_box_mail_count (const char *box, int *unread);
extern void  maildir_dump_place (memchunk_t *memchunk, mail_t *mail);
extern char *maildir_dump_file_name (mail_array_t *marray);
extern void  maildir_empty_box (const char *box);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER maildir.h
 *
 ****************************************************************************/
#endif
