
from elisa.core.tests import component_test_case
from elisa.plugins.good.media_good.gst_metadata import GstMetadata
from elisa.core import media_uri

from twisted.internet import reactor
import os

class TestGstMetadata(component_test_case.ComponentTestCase):

    component_class = GstMetadata

    def test_able_to_handle(self):
        uri = media_uri.MediaUri('file://')

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type': 'audio'})
        self.assertEqual(able, True)

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type': 'video'})
        self.assertEqual(able, True)

        able = self.component.able_to_handle({'uri': uri,
                                              'content-type':'directory'})

        self.assertEqual(able, False)

    def test_get_metadata(self):
        uri = media_uri.MediaUri("file://./../elisa/plugins/good/media_good/tests/data/test.ogg")

        def dict_filled(dict):
            static_tags = {'album': u'httpopenmusiclinuxtagorg',
                           'comment': u'audiotest wave',
                           'description': u'audiotest wave',
                           'encoder-version': 0L, 'track-number': 1L,
                           'artist': u'open_music', 'track': 1L,
                           'bitrate': 80000L, 'nominal-bitrate': 80000L,
                           'album-disc-number': 0L,
                           'uri':uri,
                           'encoder': u'Xiph.Org libVorbis I 20050304',
                           'content-type': 'audio', 'genre': u'Other',
                           'title': u'open_source__magic_mushrooms',
                           'song': u'open_source__magic_mushrooms',
                           'audio-codec': u'Vorbis'}
            self.assertEqual(dict, static_tags)

        dfr = self.component.get_metadata({'uri': uri,
                                           'content-type':'audio'})
        dfr.addCallback(dict_filled)
        return dfr
