# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
TaglibMetadataProvider component class
"""


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'
__maintainer2__ = 'Philippe Normand <philippe@fluendo.com>'


from elisa.base_components.metadata_provider import MetadataProvider
import tagpy

from twisted.internet import threads

class TaglibMetadata(MetadataProvider):

    def get_rank(self):
        return 0

    def able_to_handle(self, metadata):
        content_type = metadata.get('content-type', '')
        uri = metadata.get('uri')
        able = uri and uri.scheme == 'file' and content_type == 'audio'
        return able
    
    def get_metadata(self, metadata):
        d = threads.deferToThread(self._retrieve_metadata, metadata)
        return d


    def _retrieve_metadata(self, metadata):

        uri = metadata['uri']
        tags = {}

        if uri.extension in ('ogg', 'mp3', 'mpc', 'flac'):

            # FIXME: TagPy doesn't support unicode
            filename = uri.path.encode('utf-8')

            self.info('Parsing tags of %s', filename)
            f = tagpy.FileRef(filename)
            t = f.tag()
            self.debug('Got tags %s', t)

            if t is not None:
                
                for attr,default in (('artist',''), ('album',''),
                                     ('title',''), ('track',0)):
                    value = getattr(t, attr)
                    if callable(value):
                        value = value()
                    value = value or default
                    if isinstance(default, basestring):
                        value = value.rstrip()
                    tags[attr] = value
                    
                tags['song'] = tags['title']
                del tags['title']

                for key, value in tags.items():
                    if metadata.has_key(key):
                        if metadata[key] == None:
                            metadata[key] = value
                    else:
                        metadata[key] = value

        return metadata
