# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006,2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
mmslist Component Class
"""


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.media_provider import MediaProvider
from elisa.core.media_uri import MediaUri
from elisa.core import common

from elisa.extern.translation import gettexter, N_
T_ = gettexter('elisa-base')

from elisa.core.bus import bus_message

from twisted.internet import defer, threads

_IBN = 'mms://a150.l2584248272.c25842.g.lm.akamaistream.net/D/150/25842/v0001/reflector:48272'

class MmslistMedia(MediaProvider):
    """
    This media provider simply ships a list of mms-channels
    """

    default_config = {'streams' : [_IBN,],
                      _IBN: {'label': 'ibn'}
                      }

    def initialize(self):
        uri = "mmslist:///"
        action_type = bus_message.MediaLocation.ActionType.LOCATION_ADDED
        msg = bus_message.InternetLocation(action_type,
                                            T_(N_("MMS channels")),
                                            'mms',
                                            uri,
                                            media_types=['video',])
        common.application.bus.send_message(msg)
        self._init_streams()

    def _init_streams(self):
        self._streams = {}
        for stream_uri in self.config.get('streams',[]):
            uri = MediaUri(stream_uri)
            stream_opts = self.config.get(str(uri), {'label': uri.label})
            label = stream_opts['label']
            self._streams[label] = uri
        
    def supported_uri_schemes__get(self):
        return { 'mmslist': 0 }

    def scannable_uri_schemes__get(self):
        return []

    def blocking_get_media_type(self, uri):
        if self.blocking_is_directory(uri):
            return {'file_type' : 'directory',
                    'mime_type' : 'mime_type'}

        return {'file_type' : 'video', 'mime_type' : 'mms'}

    def blocking_is_directory(self, uri):
        if uri.path == '/':
            return True
        elif uri.path == '':
            return  True

        return False

    def get_media_type(self, uri):
        d = threads.deferToThread(self.blocking_get_media_type,
                                  uri)
        return d


    def has_children_with_types(self, uri, media_types):
        d = threads.deferToThread(self.blocking_has_children_with_types,
                                  uri, media_types)
        return d

    def blocking_has_children_with_types(self, uri, media_types):
        if self.blocking_is_directory(uri):
            if 'video' in media_types:
                return True
        return False

    def blocking_get_direct_children(self, uri, list_of_children):

        if self.blocking_is_directory(uri):
            for key in self._streams.keys():
                chi_uri = MediaUri(self._streams[key])
                chi_uri.label = key
                chi_uri.scheme = 'mmslist'
                dict = {'file_type' : 'video',
                        'mime_type' : 'mms'}
                list_of_children.append( (chi_uri, dict) )
        return list_of_children

    def get_direct_children(self, uri, l):
        d = threads.deferToThread(self.blocking_get_direct_children, uri, l)
        return d

    def get_real_uri(self, uri):
        new_uri = MediaUri(str(uri))
        new_uri.scheme = 'mms'
        return new_uri
